% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_inspection.R
\name{check_range}
\alias{check_range}
\title{Check range}
\usage{
check_range(df, param, min_val = NULL, max_val = NULL)
}
\arguments{
\item{df}{a dataframe.}

\item{param}{character string. Name of variable of the dataframe for which to check the range.}

\item{min_val}{numeric. Define the minimum value of the range.}

\item{max_val}{numeric. Define the maximum value of the range.}
}
\value{
A numeric.
}
\description{
This function tests whether an input or output value falls within a user-defined range and return the proportion of iteration in which this is not the case.
}
\details{
If only `min_val` is specified, the proportion of iteration above this value will be computed.
If only `max_val` is specified, the proportion of iteration below this value will be computed.
}
\examples{
# Checking how often the "u_pfs" values falls within 0.55 and 0.72.
data(df_pa)
check_range(df = df_pa,
            param = "u_pfs",
            min_val = 0.55,
            max_val = 0.72
                 )
}
