% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep.R
\name{keep_hba1c}
\alias{keep_hba1c}
\title{Keep rows with HbA1c above the required threshold.}
\usage{
keep_hba1c(lab_forsker)
}
\arguments{
\item{lab_forsker}{The \code{lab_forsker} register.}
}
\value{
An object of the same input type, as a \code{\link[duckplyr:duckdb_tibble]{duckplyr::duckdb_tibble()}},
with three columns:
\itemize{
\item \code{pnr}: Personal identification variable.
\item \code{dates}: The dates of all elevated HbA1c test results.
}
}
\description{
In the \code{lab_forsker} register, NPU27300 is HbA1c in the modern units (IFCC)
while NPU03835 is HbA1c in old units (DCCT). Multiple elevated results on the
same day within each individual are deduplicated, to account for the same
test result often being reported twice (one for IFCC, one for DCCT units).
}
\details{
The output is passed to the \code{\link[=drop_pregnancies]{drop_pregnancies()}} function for
filtering of elevated results due to potential gestational diabetes (see
below).
}
\keyword{internal}
