% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSSQLResourceConnector.R
\docType{class}
\name{MSSQLResourceConnector}
\alias{MSSQLResourceConnector}
\title{MS SQL DBI resource connector}
\format{
A R6 object of class MSSQLResourceConnector
}
\description{
MS SQL DBI resource connector

MS SQL DBI resource connector
}
\details{
Makes a ODBC DBI connection to a MS SQL server from a resource description.
}
\examples{
\dontrun{
# Create a resource
res <- resourcer::newResource(
  url = "odbc+mssql://localhost:1433/EpidemiologyDB/PatientData", 
  identity = "sa", secret = "YourStrong@Password123")
# Create a resource client
client <- resourcer::newResourceClient(res)
# Coerce resource to a data frame
df <- client$asDataFrame()
# Disconnect the client
client$close()
}

}
\section{Super classes}{
\code{\link[resourcer:DBIResourceConnector]{resourcer::DBIResourceConnector}} -> \code{\link[odbc.resourcer:ODBCResourceConnector]{odbc.resourcer::ODBCResourceConnector}} -> \code{MSSQLResourceConnector}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MSSQLResourceConnector-new}{\code{MSSQLResourceConnector$new()}}
\item \href{#method-MSSQLResourceConnector-isFor}{\code{MSSQLResourceConnector$isFor()}}
\item \href{#method-MSSQLResourceConnector-getConnectionParameters}{\code{MSSQLResourceConnector$getConnectionParameters()}}
\item \href{#method-MSSQLResourceConnector-clone}{\code{MSSQLResourceConnector$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="resourcer" data-topic="DBIResourceConnector" data-id="closeDBIConnection"><a href='../../resourcer/html/DBIResourceConnector.html#method-DBIResourceConnector-closeDBIConnection'><code>resourcer::DBIResourceConnector$closeDBIConnection()</code></a></span></li>
<li><span class="pkg-link" data-pkg="resourcer" data-topic="DBIResourceConnector" data-id="getTableName"><a href='../../resourcer/html/DBIResourceConnector.html#method-DBIResourceConnector-getTableName'><code>resourcer::DBIResourceConnector$getTableName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="resourcer" data-topic="DBIResourceConnector" data-id="readDBTable"><a href='../../resourcer/html/DBIResourceConnector.html#method-DBIResourceConnector-readDBTable'><code>resourcer::DBIResourceConnector$readDBTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="resourcer" data-topic="DBIResourceConnector" data-id="readDBTibble"><a href='../../resourcer/html/DBIResourceConnector.html#method-DBIResourceConnector-readDBTibble'><code>resourcer::DBIResourceConnector$readDBTibble()</code></a></span></li>
<li><span class="pkg-link" data-pkg="odbc.resourcer" data-topic="ODBCResourceConnector" data-id="createDBIConnection"><a href='../../odbc.resourcer/html/ODBCResourceConnector.html#method-ODBCResourceConnector-createDBIConnection'><code>odbc.resourcer::ODBCResourceConnector$createDBIConnection()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MSSQLResourceConnector-new"></a>}}
\if{latex}{\out{\hypertarget{method-MSSQLResourceConnector-new}{}}}
\subsection{Method \code{new()}}{
Creates a new MSSQLResourceConnector instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MSSQLResourceConnector$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A MSSQLResourceConnector object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MSSQLResourceConnector-isFor"></a>}}
\if{latex}{\out{\hypertarget{method-MSSQLResourceConnector-isFor}{}}}
\subsection{Method \code{isFor()}}{
Check that the provided resource has a URL that locates a MS SQL object: the URL scheme must be "odbc+mssql".
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MSSQLResourceConnector$isFor(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{The resource object to validate.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A logical.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MSSQLResourceConnector-getConnectionParameters"></a>}}
\if{latex}{\out{\hypertarget{method-MSSQLResourceConnector-getConnectionParameters}{}}}
\subsection{Method \code{getConnectionParameters()}}{
Get the MS SQL ODBC driver connection string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MSSQLResourceConnector$getConnectionParameters(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{A valid resource object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The MS SQL ODBC driver connection parameters list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MSSQLResourceConnector-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MSSQLResourceConnector-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MSSQLResourceConnector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
