\name{polygonal}
\alias{polygonal}
\title{
  Polygonal Numbers
}
\description{
  Computes the k-polygonal number(s) for an integer or a sequence of integers.
}
\usage{
  polygonal(k, n)
}
\arguments{
  \item{k}{single natural number, the number of sides of the polygon.}
  \item{n}{the n-th number of all k-polygonal number; can be a vector.}
}
\details{
  A polygonal number is a number of dots that can be laid out to form a regular 
  k-sided polygon, incl. triangular (k=3), square (k=4), pentagonal (k=5) and 
  hexagonal (k=6) numbers. See the Wikipedia article "Polygonal Numbers" for
  visualizations of these \emph{figurative numbers}
  .

  \code{k=3  Triangular:  1   3   6  10  15  21  28  36  45  55 ...}\cr
  \code{k=4  Square    :  1   4   9  16  25  36  49  64  81 100 ...}\cr
  \code{k=5  Pentagonal:  1   5  12  22  35  51  70  92 117 145 ...}\cr
  \code{k=6  Hexagonal :  1   6  15  28  45  66  91 120 153 190 ...}\cr
  \code{...}
}
\value{
  A natural number or a vector of such numbers.
}
\references{
S.A. Khan. Sums of Reciprocals of Polygonal Numbers and a Theorem of Gauss.
Intern. Journal of Applied Mathematics. Vol. 33 (2020), No. 2, pp. 265-282.

CCY Kwan. The Sum of Reciprocals of Polygonal Numbers: A Spreadsheet-Based
Illustration. 'Spreadsheets in Education' Journal, August 2025.
}
\note{
  According to theorems of Gauss and Cauchy, every natural number is the sum of 
  three triangular numbers or the sum of k k-th polygonal numbers (incl. zero).

  To determine the sum of reciprocals of polygonal numbers through the special 
  mathematical functions is an ongoing topic of research since 2007.
}
\seealso{
  the arithmetic progression function \code{arithmetic_progression()}.
}
\examples{
polygonal(3, 1:10)  #  1   3   6  10  15  21  28  36  45  55
polygonal(4, 1:10)  #  1   4   9  16  25  36  49  64  81 100
polygonal(5, 1:10)  #  1   5  12  22  35  51  70  92 117 145
polygonal(6, 1:10)  #  1   6  15  28  45  66  91 120 153 190

# Sums of reciprocals of polygonal numbers:
n = 1000
sum(1/polygonal(3, 1:n)) # 1.998002 -> 2.0
sum(1/polygonal(4, 1:n)) # 1.643935 -> pi^2/6
sum(1/polygonal(5, 1:n)) # 1.481371 -> 3*log(3)-pi/sqrt(3)
sum(1/polygonal(6, 1:n)) # 1.385794 -> 2*log(2)
}
