##
##  p o l y g o n a l . R
##


polygonal <- function(k, n) {
    stopifnot(is.numeric(k), is.numeric(n))
    if (length(k) != 1 || k < 2)
        stop(stop("Argument 'k' must be a natural number > 1."))
    if (floor(k) != ceiling(k) ||
        any(floor(n) != ceiling(n)))
        stop("Arguments 'k' and 'n' must be integers.")

    s <- ((k-2)*n^2 - (k-4)*n)/2
    return(s)
}

# is.polygonal <- function(x) {
#     n <- (sqrt(8*(k-2)*x + (k-4)^2) + (k-4))/(2*(k-2))
#     s <- 2 + (2/n)*(x-n)/(n-1)
# }

# k=3  Triangular:  1   3   6  10  15  21  28  36  45  55
# k=4  Square    :  1   4   9  16  25  36  49  64  81 100
# k=5  Pentagonal:  1   5  12  22  35  51  70  92 117 145
# k=6  Hexagonal :  1   6  15  28  45  66  91 120 153 190
#

# Sums of reciprocals of polygonal numbers:
# n = 1000
# k=3  sum(1/polygonal(3, 1:n)) = 1.998002   # -> 2.0
# k=4  sum(1/polygonal(4, 1:n)) = 1.643935   # -> pi^2/6
# k=5  sum(1/polygonal(5, 1:n)) = 1.481371   # -> 3*log(3)-pi/sqrt(3)
# k=6  sum(1/polygonal(6, 1:n)) = 1.385794   # -> 2*log(2)
# ...  sum(1/polygonal(k, 1:n))              # -> 1.0 with k,n -> Inf
