% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_address_lookup.R
\name{geo_address_lookup}
\alias{geo_address_lookup}
\title{Address lookup API}
\usage{
geo_address_lookup(
  osm_ids,
  type = c("N", "W", "R"),
  lat = "lat",
  long = "lon",
  full_results = FALSE,
  return_addresses = TRUE,
  verbose = FALSE,
  nominatim_server = "https://nominatim.openstreetmap.org/",
  custom_query = list()
)
}
\arguments{
\item{osm_ids}{Vector of OSM identifiers as \strong{numeric}
(\code{c(00000, 11111, 22222)}).}

\item{type}{Vector character of the type of the OSM type associated to each
\code{osm_ids}. Possible values are node (\code{"N"}), way (\code{"W"}) or relation
(\code{"R"}). If a single value is provided it would be recycled.}

\item{lat}{Latitude column name in the output data (default  \code{"lat"}).}

\item{long}{Longitude column name in the output data (default  \code{"long"}).}

\item{full_results}{Returns all available data from the API service.
If \code{FALSE} (default) only latitude, longitude and address columns are
returned. See also \code{return_addresses}.}

\item{return_addresses}{Return input addresses with results if \code{TRUE}.}

\item{verbose}{If \code{TRUE} then detailed logs are output to the console.}

\item{nominatim_server}{The URL of the Nominatim server to use.
Defaults to \code{"https://nominatim.openstreetmap.org/"}.}

\item{custom_query}{A named list with API-specific parameters to be used
(i.e. \code{list(countrycodes = "US")}). See \strong{Details}.}
}
\value{
A \code{\link[tibble:tibble]{tibble}} with the results found by the query.
}
\description{
The lookup API allows to query the address and other details of one or
multiple OSM objects like node, way or relation. This function returns the
\code{\link[tibble:tibble]{tibble}} associated with the query, see
\code{\link[=geo_address_lookup_sf]{geo_address_lookup_sf()}} for retrieving the data as a spatial object
(\code{\link[sf:sf]{sf}} format).
}
\details{
See \url{https://nominatim.org/release-docs/develop/api/Lookup/} for additional
parameters to be passed to \code{custom_query}.
}
\examples{
\dontshow{if (nominatim_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
ids <- geo_address_lookup(osm_ids = c(46240148, 34633854), type = "W")

ids

several <- geo_address_lookup(c(146656, 240109189), type = c("R", "N"))
several
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=geo_address_lookup_sf]{geo_address_lookup_sf()}}.

Address Lookup API:
\code{\link{geo_address_lookup_sf}()}

Geocoding:
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_lite}()},
\code{\link{geo_lite_sf}()},
\code{\link{geo_lite_struct}()},
\code{\link{geo_lite_struct_sf}()}
}
\concept{geocoding}
\concept{lookup}
