% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbox_to_poly.R
\name{bbox_to_poly}
\alias{bbox_to_poly}
\title{Coerce a bounding box to a \code{\link[sf:sfc]{sfc}} \code{POLYGON} object}
\usage{
bbox_to_poly(bbox = NA, xmin = NA, ymin = NA, xmax = NA, ymax = NA, crs = 4326)
}
\arguments{
\item{bbox}{Numeric vector of 4 elements representing the coordinates of the
bounding box. Values should be \code{c(xmin, ymin, xmax, ymax)}.}

\item{xmin, ymin, xmax, ymax}{Alternatively, you can use these named parameters
instead of \code{bbox}.}

\item{crs}{coordinate reference system, something suitable as input to \link[sf]{st_crs}}
}
\value{
A \code{\link[sf:sfc]{sfc}} object of class \code{POLYGON}.
}
\description{
Create a \code{\link[sf:sfc]{sfc}} object from the coordinates of a bounding box.
}
\details{
Bounding boxes can be located using different online tools, as \href{https://boundingbox.klokantech.com/}{Bounding Box Tool}.
}
\examples{
\dontshow{if (nominatim_check_access()) withAutoprint(\{ # examplesIf}

# bounding box of Germany
bbox_GER <- c(5.86631529, 47.27011137, 15.04193189, 55.09916098)

bbox_GER_sf <- bbox_to_poly(bbox_GER)


library(ggplot2)

ggplot(bbox_GER_sf) +
  geom_sf()
\donttest{
# Extract the bounding box of a sf object
sfobj <- geo_lite_sf("seychelles", points_only = FALSE)

sfobj

# Need at least one non-empty object
if (any(!sf::st_is_empty(sfobj))) {
  bbox <- sf::st_bbox(sfobj)

  bbox

  bbox_sfobj <- bbox_to_poly(bbox)

  ggplot(bbox_sfobj) +
    geom_sf(fill = "lightblue", alpha = 0.5) +
    geom_sf(data = sfobj, fill = "wheat")
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[sf:st_as_sfc]{sf::st_as_sfc()}} and \code{\link[sf:sfc]{sf::st_sfc()}}.

Get \code{\link[sf:sf]{sf}} objects:
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_lite_sf}()},
\code{\link{geo_lite_struct_sf}()},
\code{\link{reverse_geo_lite_sf}()}
}
\concept{spatial}
