% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateOncologyXenograftSimeoni2004.R
\name{updateOncologyXenograftSimeoni2004}
\alias{updateOncologyXenograftSimeoni2004}
\title{Update an oncology xenograft model based on Simeoni 2004}
\usage{
updateOncologyXenograftSimeoni2004(
  object,
  ncmt,
  damagedCmtName = "damagedCells",
  drugEffectName = "drugEffectCyclingCells",
  undamagedCmtName = "cyclingCells",
  tumorVolName = "tumorVol",
  transitRateName = "damageTransit"
)
}
\arguments{
\item{object}{Fitted object or function specifying the model.}

\item{ncmt}{The desired number of damaged cell compartments}

\item{damagedCmtName, undamagedCmtName, tumorVolName}{character string names
for the compartments for damaged cells, undamaged cells, and the calculated
tumor volume (the sum of undamaged and damaged cells)}

\item{drugEffectName, transitRateName}{character string names of the drug effect and transit rate (as used in the model block)}
}
\value{
An updated model with the new number of compartments
}
\description{
Update an oncology xenograft model based on Simeoni 2004
}
\examples{
library(rxode2)
readModelDb("oncology_xenograft_simeoni_2004") \%>\%
  updateOncologyXenograftSimeoni2004(ncmt = 5)
}
