% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_modelfit.R
\name{run_npd_1cmpt_mm_iv}
\alias{run_npd_1cmpt_mm_iv}
\title{Run and evaluate a one-compartment IV Michaelis-Menten model}
\usage{
run_npd_1cmpt_mm_iv(
  dat,
  est.method = "nls",
  npdmm_inputvmax = exp(1),
  npdmm_inputkm = exp(1),
  npdmm_inputcl = exp(1),
  npdmm_inputvd = exp(1),
  input.add = 1,
  km_threshold = FALSE
)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic data in standard nlmixr2
format.}

\item{est.method}{Estimation method used in nlmixr2. Defaults to "nls".}

\item{npdmm_inputvmax}{Initial estimate for Vmax. Defaults to exp(1),
corresponding to a log-scale value of 1.}

\item{npdmm_inputkm}{Initial estimate for Km. Defaults to exp(1),
corresponding to a log-scale value of 1.}

\item{npdmm_inputcl}{Initial estimate for clearance (CL). Defaults to exp(1)
, corresponding to a log-scale value of 1.}

\item{npdmm_inputvd}{Initial estimate for volume of distribution (Vd).
Defaults to exp(1), corresponding to a log-scale value of 1.}

\item{input.add}{Additive error term. Defaults to 1.}

\item{km_threshold}{Logical value. If TRUE, initial estimates for Vmax and Km
are calculated based on the maximum observed concentration.}
}
\value{
A list containing parameter estimates and prediction error metrics.
}
\description{
Fits a one-compartment intravenous pharmacokinetic model with
Michaelis-Menten elimination using a naive pooled data approach and evaluates
model performance based on prediction error metrics.
}
\details{
Rows where \code{EVID == 2} are excluded before model fitting. The model is
fitted using \code{Fit_1cmpt_mm_iv}. When \code{km_threshold = TRUE}, initial estimates
for Vmax and Km are derived from the dataset to provide a representative
starting point for nonlinear elimination.
}
\examples{
\donttest{
run_npd_1cmpt_mm_iv(
  dat = Bolus_1CPT,
  npdmm_inputcl = 4,
  npdmm_inputvd = 70,
  km_threshold = TRUE
)
}

}
\seealso{
\code{\link{Fit_1cmpt_mm_iv}}
}
\author{
Zhonghui Huang
}
