% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{string_to_var}
\alias{string_to_var}
\title{Create a syntactically valid variable name from a string}
\usage{
string_to_var(str)
}
\arguments{
\item{str}{string}
}
\value{
a syntactically valid variable name
}
\description{
Spaces are replaced with '_' and other non valid characters are encoded as '.' + two bit
hexadecimal representation.
Variables which start with an underscore or a dot are prepended with the letter 'X'.
The result is sent to \code{make.names} in order to deal with reserved words.
}
\details{
Note that strings starting with 'X.' would not be translated back correctly using \code{var_to_string},
i.e. \code{string_to_var(var_to_string("X.saba"))} would result ".saba".
}
\examples{
string_to_var("a & b")
string_to_var("saba and savta")
string_to_var("/home/mydir")
string_to_var("www.google.com")
string_to_var("my_variable + 3")
string_to_var(".hidden variable")
string_to_var("NULL")

}
