% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARC.R
\name{ARC}
\alias{ARC}
\title{Calculate several measures of Area Relative Curvature}
\usage{
ARC(plyFile, BoundaryDiscard = "Vertex", Range = c(0.01, 0.99))
}
\arguments{
\item{plyFile}{An object of classes 'mesh3d' and 'shape3d' with calculated normals}

\item{BoundaryDiscard}{String indicating how to handle the exclusion of
boundary faces. Default of Vertex excludes faces which have at least 1 vertex
on the boundary}

\item{Range}{A pair of values which set lower and upper outlier exclusions.}
}
\description{
A function that calculates the average slope over a tooth
or some other 3D surface
}
\details{
The function requires an object created by reading in a ply file.

This function calculates Area Relative Curvature, as described by Guy et al. (2013)
}
\examples{
arc_output <- ARC(Tooth)
summary(arc_output)
}
