% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_poi_prelim.R
\name{sim_poi_prelim}
\alias{sim_poi_prelim}
\title{Simulate Preliminary Investigation Data for Persons of Interest}
\usage{
sim_poi_prelim(
  casetype = "children",
  dateinit = "1975/01/01",
  scenario = 1,
  femaleprop = 0.5,
  ext = 100,
  numsims = 10000,
  seed = 123,
  birthprob = c(0.09, 0.9, 0.01),
  region = c("North America", "South America", "Africa", "Asia", "Europe", "Oceania"),
  regionprob = c(0.2, 0.2, 0.2, 0.1, 0.2, 0.1)
)
}
\arguments{
\item{casetype}{Character. Type of missing person case:
\itemize{
\item "children": Generates birth date, sex, birth type, and region
\item "migrants": Generates age, sex, height, and region
}
Default: "children".}

\item{dateinit}{Character. Minimum birth date for simulated POIs in
"YYYY/MM/DD" format. Only used for casetype = "children".
Default: "1975/01/01".}

\item{scenario}{Integer (1 or 2). Birth date distribution scenario:
\itemize{
\item 1: Non-uniform (gamma distribution, more realistic)
\item 2: Uniform distribution
}
Only used for casetype = "children". Default: 1.}

\item{femaleprop}{Numeric (0-1). Proportion of females in the simulated
population. Default: 0.5.}

\item{ext}{Numeric. Extension parameter:
\itemize{
\item Scenario 1: Scale factor for gamma distribution
\item Scenario 2: Number of days range
}
Default: 100.}

\item{numsims}{Integer. Number of POIs/UHRs to simulate. Default: 10000.}

\item{seed}{Integer. Random seed for reproducibility. Default: 123.}

\item{birthprob}{Numeric vector of length 3. Probabilities for birth type:
c(home_birth, hospital_birth, unknown/adoption). Only for "children".
Default: c(0.09, 0.9, 0.01).}

\item{region}{Character vector. Names of regions/locations. Default:
c("North America", "South America", "Africa", "Asia", "Europe", "Oceania").}

\item{regionprob}{Numeric vector. Probabilities for each region.
Must sum to 1 and have same length as \code{region}.
Default: c(0.2, 0.2, 0.2, 0.1, 0.2, 0.1).}
}
\value{
A data.frame with columns depending on casetype:
\itemize{
\item \strong{children}: POI-ID, DBD (declared birth date), Sex,
Birth-type, Region
\item \strong{migrants}: UHR-ID, Age, Sex, Height, Region
}
}
\description{
Generates a simulated database of preliminary investigation data for
persons of interest (POIs) or unidentified human remains (UHRs). Supports
two case types: missing children and missing migrants.
}
\details{
For missing children cases, this function simulates characteristics of
children who may have been taken during periods of conflict or human rights
violations, with their identity documents potentially falsified.

For missing migrants cases, this simulates characteristics of unidentified
human remains that may correspond to missing migrants.

The birth date distribution in scenario 1 uses a gamma distribution with
shape=12, which creates a more realistic non-uniform pattern of births.
}
\examples{
# Simulate children case database
db_children <- sim_poi_prelim(
  casetype = "children",
  dateinit = "1975/01/01",
  scenario = 1,
  numsims = 100,
  seed = 123
)
head(db_children)

# Simulate migrants case database
db_migrants <- sim_poi_prelim(
  casetype = "migrants",
  numsims = 100,
  seed = 456
)
head(db_migrants)
summary(db_migrants$Age)
}
\references{
Marsico FL, et al. (2023). "Likelihood ratios for non-genetic evidence
in missing person cases." \emph{Forensic Science International: Genetics},
66, 102891. \doi{10.1016/j.fsigen.2023.102891}
}
\seealso{
\code{\link{sim_mp_prelim}} for simulating missing person data,
\code{\link{sim_lr_prelim}} for using this data in LR calculations.
}
