% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrl.R
\name{tstab.mrl}
\alias{tstab.mrl}
\title{Mean residual life plot}
\usage{
tstab.mrl(
  xdat,
  thresh,
  kmin = 10L,
  kmax = length(xdat),
  plot = TRUE,
  level = 0.95,
  xlab = c("thresh", "nexc"),
  type = c("band", "ptwise"),
  ...
)
}
\arguments{
\item{xdat}{vector of sample observations}

\item{thresh}{vector of thresholds}

\item{kmin}{integer giving the minimum number of exceedances; ignored if \code{thresh} is provided. Default to 10}

\item{kmax}{integer giving the maximum number of exceedances; ignored if \code{thresh} is provided. Default to sample size.}

\item{plot}{logical; if \code{TRUE}, call the plot method}

\item{level}{double giving the level of confidence intervals for the plot, default to 0.95}

\item{xlab}{string indicating whether to use thresholds (\code{thresh}) or number of largest order statistics (\code{nexc}) for the x-axis}

\item{type}{string whether to plot pointwise confidence intervals using segments (\code{"ptwise"}) or using dashed lines (\code{"band"})}

\item{...}{additional arguments, currently ignored}
}
\value{
an invisible list with mean sample exceedances and standard deviation, number of exceedances, threshold
}
\description{
Computes mean of sample exceedances over a range of thresholds or for a pre-specified number of largest order statistics, and returns a plot with 95\% Wald-based confidence intervals as a function of either the threshold or the number of exceedances. The main purpose is the plotting method, which generates the so-called mean residual life plot. The latter should be approximately linear over the threshold for a generalized Pareto distribution
}
\examples{
tstab.mrl(
 xdat = rgp(n = 100, shape = -0.5),
 xlab = "thresh",
 kmax = 50)
tstab.mrl(
 rexp(100),
 thresh = qexp(seq(0, 0.9, by = 0.01)))
}
\references{
Davison, A.C. and R.L. Smith (1990). Models for Exceedances over High Thresholds (with discussion), \emph{Journal of the Royal Statistical Society. Series B (Methodological)}, \bold{52}(3), 393--442.
}
