% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_quantile_smooth}
\alias{normalize_quantile_smooth}
\title{Normalize intensities across samples using smooth Quantile Normalization (qsmooth)}
\usage{
normalize_quantile_smooth(
  data,
  group_column = .data$Group,
  rolling_window = 0.05
)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{group_column}{Which column should be used for grouping? Usually \code{grouping_column = Group}. Uses \code{\link[rlang]{args_data_masking}}.}

\item{rolling_window}{\code{normalize_quantile_smooth} uses a rolling window median to eliminate isolated outliers. This argument specifies the size of the rolling window as a fraction of the number of unique features in \code{data}. For example, if there are 100 features in \code{data} and \code{rolling_window = 0.05}, the rolling median will be calculated from 5 features. Set \code{rolling_window = 0} to disable.}
}
\value{
A tibble with intensities normalized across samples.
}
\description{
This function performs a smooth Quantile Normalization on each sub-group in the data set (qsmooth). \strong{It therefore requires grouping information}. See
Examples for more information. This approach might perform better than the standard approach, \code{\link[metamorphr]{normalize_quantile_all}},
if sub-groups are very different (e.g., when comparing cancer vs. normal tissue). The result lies somewhere between \code{\link[metamorphr]{normalize_quantile_group}}
and \code{\link[metamorphr]{normalize_quantile_all}}. Basically a re-implementation of Hicks \emph{et al.} (2018).
}
\examples{
toy_metaboscape \%>\%
  # Metadata, including grouping information, must be added before using normalize_quantile_group()
  join_metadata(toy_metaboscape_metadata) \%>\%
  normalize_quantile_smooth(group_column = Group)
}
\references{
\itemize{
\item S. C. Hicks, K. Okrah, J. N. Paulson, J. Quackenbush, R. A. Irizarry, H. C. Bravo, \emph{Biostatistics} \strong{2018}, \emph{19}, 185–198, DOI 10.1093/biostatistics/kxx028.
\item Y. Zhao, L. Wong, W. W. B. Goh, \emph{Sci Rep} \strong{2020}, \emph{10}, 15534, DOI 10.1038/s41598-020-72664-6.
}
}
