% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{context}
\alias{context}
\alias{current_row_info}
\alias{current_column_info}
\alias{current_n_row}
\alias{current_n_column}
\alias{current_row_name}
\alias{row_pos}
\alias{row_rel_pos}
\alias{current_column_name}
\alias{column_pos}
\alias{column_rel_pos}
\title{Contexts dependent functions}
\usage{
current_row_info()

current_column_info()

current_n_row()

current_n_column()

current_row_name()

row_pos()

row_rel_pos()

current_column_name()

column_pos()

column_rel_pos()
}
\value{
See each individual functions for returned value when used in proper context.
If used out of context, an error condition is issued.
}
\description{
These functions are designed to work inside certain \code{matrixset} functions, to
have access to current group/matrix/row/column. Because of that, they will
not work in a general context.

The functions within which the context functions will work are \code{\link[=apply_matrix]{apply_matrix()}},
\code{\link[=apply_row]{apply_row()}} and \code{\link[=apply_column]{apply_column()}} - as well as their *_dfl/*dfw variant.

Note that "current" refers to the current matrix/group/row/column, as
applicable, and possibly combined.

The context functions are:
\itemize{
\item \code{current_n_row()} and \code{current_n_column()}. They each give the number of rows
and columns, respectively, of the current matrix.

They are the context equivalent of \code{\link[=nrow]{nrow()}} and \code{\link[=ncol]{ncol()}}.
\item \code{current_row_name()} and \code{current_column_name()}. They provide the current
row/column name. They are the context equivalent of \code{\link[=rownames]{rownames()}} and
\code{\link[=colnames]{colnames()}}.
\item \code{current_row_info()} and \code{current_column_info()}. They give access to the
current row/column annotation data frame. The are the context equivalent
of \code{\link[=row_info]{row_info()}} and \code{\link[=column_info]{column_info()}}.
\item \code{row_pos()} and \code{column_pos()}. They give the current row/column indices.
The indices are the the ones before matrix subsetting.
\item \code{row_rel_pos()} and \code{column_rel_pos()}. They give the row/column indices
relative to the current matrix. They are equivalent to
\code{seq_len(current_n_row())}/\code{seq_len(current_n_column())}.
}
}
\examples{
# this will fail (as it should), because it is used out of context
is(try(current_n_row(), silent = TRUE), "try-error")

# this is one way to know the number of students per class in 'student_results'
sr <- row_group_by(student_results, class)
apply_matrix_dfl(sr, n = ~ current_n_row(), .matrix = 1)

}
