% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corner.R
\name{arc}
\alias{arc}
\title{Draw an arc showing the angle between vectors}
\usage{
arc(p1, p2, p3, d = 0.1, absolute = TRUE, ...)
}
\arguments{
\item{p1}{Starting point of first vector}

\item{p2}{End point of first vector, and also start of second vector}

\item{p3}{End point of second vector}

\item{d}{The distance from \code{p2} along each vector for drawing their corner}

\item{absolute}{logical; if \code{TRUE}, \code{d} is taken as an absolute distance along the vectors; otherwise it
is calculated as a relative distance, i.e., a fraction of the length of the vectors.}

\item{...}{Arguments passed to \code{\link[graphics]{lines}} or to \code{\link[rgl]{lines3d}}}
}
\value{
none
}
\description{
A utility function for drawing vector diagrams. Draws a circular arc to show the angle between two vectors in 2D or 3D.
}
\details{
In this implementation, the two vectors are specified by three points, \code{p1}, \code{p2}, \code{p3}, meaning
a line from \code{p1} to \code{p2}, and another line from \code{p2} to \code{p3}.
}
\examples{
library(rgl)
vec <- rbind(diag(3), c(1,1,1))
rownames(vec) <- c("X", "Y", "Z", "J")
open3d()
aspect3d("iso")
vectors3d(vec, col=c(rep("black",3), "red"), lwd=2)
# draw the XZ plane, whose equation is Y=0
planes3d(0, 0, 1, 0, col="gray", alpha=0.2)
# show projections of the unit vector J
segments3d(rbind( c(1,1,1), c(1, 1, 0)))
segments3d(rbind( c(0,0,0), c(1, 1, 0)))
segments3d(rbind( c(1,0,0), c(1, 1, 0)))
segments3d(rbind( c(0,1,0), c(1, 1, 0)))
segments3d(rbind( c(1,1,1), c(1, 0, 0)))

# show some orthogonal vectors
p1 <- c(0,0,0)
p2 <- c(1,1,0)
p3 <- c(1,1,1)
p4 <- c(1,0,0)
# show some angles
arc(p1, p2, p3, d=.2)
arc(p4, p1, p2, d=.2)
arc(p3, p1, p2, d=.2)
}
\references{
\url{https://math.stackexchange.com/questions/1507248/find-arc-between-two-tips-of-vectors-in-3d}
}
\seealso{
Other vector diagrams: 
\code{\link{Proj}()},
\code{\link{arrows3d}()},
\code{\link{circle3d}()},
\code{\link{corner}()},
\code{\link{plot.regvec3d}()},
\code{\link{pointOnLine}()},
\code{\link{regvec3d}()},
\code{\link{vectors}()},
\code{\link{vectors3d}()}
}
\concept{vector diagrams}
