#' Methods for mc objects.
#' 
#' Methods for mc objects.
#' 
#' @usage \method{as.data.frame}{mc}(x, ...)
#' @param x An object of class mc.
#' @param ... Arguments passed to \code{\link[base]{as.data.frame}}.
#' 
#' @return A data frame.
#' @author Mehdi Moradi \email{m2.moradi@yahoo.com}
#' @export
as.data.frame.mc <- function(x, ...) {
  
  # If x is already a data.frame, just return it
  if (is.data.frame(x))
    return(x)
  
  # Convert to data.frame while preserving column names
  if(all(class(unclass(x)) == "list") && attr(x, "type") == "local"){
    df <- lapply(X=1:length(unclass(x)), function(i){
      as.data.frame.mc(x[[i]])
    })
    names(df) <- names(x)
    return(df)
  }else{
    df <- as.data.frame(unclass(x), ...)
  }
  return(df)
}