% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_functions.R
\name{cv_coint_maki}
\alias{cv_coint_maki}
\title{Get Critical Values for Maki Cointegration Test}
\usage{
cv_coint_maki(n, m, model)
}
\arguments{
\item{n}{Sample size (currently not used as values are asymptotic).}

\item{m}{Number of breaks (0-5).}

\item{model}{Model specification (0-3):
\itemize{
  \item 0: Level shift
  \item 1: Level shift with trend
  \item 2: Regime shift
  \item 3: Trend and regime shift
}}
}
\value{
Numeric vector of critical values at 1\%, 5\%, and 10\% significance levels.
}
\description{
Returns critical values for the Maki cointegration test based on 
Maki (2012) Table 1.
}
\examples{
# Get critical values for m=1, model=0
cv_coint_maki(100, m=1, model=0)
}
