% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symtable.R
\name{symput}
\alias{symput}
\title{Assign a Variable in the Macro Symbol Table}
\usage{
symput(x, value = NULL)
}
\arguments{
\item{x}{The name of the macro variable to assign,
passed as a quoted string with no leading ampersand or trailing
dot (".").  The leading ampersand will be added automatically
by the function.  This parameter is required.}

\item{value}{The value of the macro variable to assign.
Value will be converted to a character string. This parameter is
not required.  If the value parameter is not supplied, the variable
will be removed from the symbol table.}
}
\value{
The macro name, invisibly.
}
\description{
The \code{symput} function assigns the value of a macro
variable from regular R code.
}
\examples{
library(macro)

# Get path to demo macro program
src <- system.file("extdata/Demo3.R", package = "macro")

# Display source code
# - This is the macro input code
cd <- readLines(src)
cat(paste(cd, "\n"))
# #\% Determine appropriate data path
# #\%if ("&env." == "prod")
#   #\%let pth <- /projects/prod/data
# #\%else
#   #\%let pth <- /projects/dev/data
# #\%end

# Set env macro variable using symput()
symput("env", "prod")

# Macro Execute Source Code
# - set clear to FALSE to so "env" value is not removed
msource(src, echo = FALSE, clear = FALSE)

# View "pth" macro variable
res <- symget("pth")

# View results
# - Path is set to the "prod" value
res
# [1] "/projects/prod/data"

}
\seealso{
\code{\link[=msource]{msource()}}

Other symtable: 
\code{\link{print.symtable}()},
\code{\link{symclear}()},
\code{\link{symget}()},
\code{\link{symtable}()}
}
\concept{symtable}
