% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_experiment.R
\name{run_experiment}
\alias{run_experiment}
\title{Run a NetLogo BehaviorSpace experiment}
\usage{
run_experiment(
  netlogo_path,
  model_path,
  experiment = NULL,
  setup_file = NULL,
  other_arguments = NULL,
  parse = TRUE
)
}
\arguments{
\item{netlogo_path}{A string specifying the path to the NetLogo executable.
In Windows, this is usually something like
\verb{C:\\Program Files\\NetLogo 7.0.0\\NetLogo.exe}.}

\item{model_path}{A string specifying the path to the NetLogo model file
(with extension \code{.nlogo}, \code{.nlogo3d}, \code{.nlogox}, or \code{.nlogox3d}).}

\item{experiment}{(optional) A string specifying the name of the experiment
defined in the NetLogo model file (default: \code{NULL}).}

\item{setup_file}{(optional) A string specifying the path to an XML file
containing the experiment definition. This file can be created using
\code{\link[=create_experiment]{create_experiment()}} or exported from the
NetLogo BehaviorSpace interface (default: \code{NULL}).}

\item{other_arguments}{(optional) A \code{\link[=character]{character}} vector
specifying any additional command-line arguments to pass to the NetLogo
executable. For example, you can use \code{c("--threads 4")} to specify the
number of threads to use (default: \code{NULL}).}

\item{parse}{(optional) A \code{\link[=logical]{logical}} flag indicating whether to
parse NetLogo lists in the output data frame. If \code{TRUE}, columns containing
NetLogo lists (e.g., \verb{[1 2 3]}) will be converted to R lists. If \code{FALSE},
the columns will remain as \code{\link[=character]{character}} strings
(default: \code{TRUE}).}
}
\value{
A \code{\link[dplyr:reexports]{tibble}} containing the results of the
experiment.
}
\description{
\code{run_experiment()} runs a NetLogo BehaviorSpace experiment in headless mode
and returns the results as a tidy data frame. It can be used with
\code{\link[=create_experiment]{create_experiment()}} to create the experiment XML
file on the fly, or with an existing experiment stored in the NetLogo model
file.

Please refer to the
\href{https://docs.netlogo.org/behaviorspace.html}{BehaviorSpace Guide} for
complete guidance on how to set and run experiments in NetLogo.
}
\examples{
# Set the Environment -----

## Change the path below to point to your NetLogo executable.
netlogo_path <- file.path("", "opt", "netlogo-7-0-0", "bin", "NetLogo")

## Change the path below to point to the 'Wolf Sheep Simple 5' NetLogo
## model file in the Model Library.
model_path <- file.path(
  "", "opt", "netlogo-7-0-0", "models", "IABM Textbook", "chapter 4",
  "Wolf Sheep Simple 5.nlogox"
)

# Using `create_experiment()` to Create the Experiment XML File -----

\dontrun{
  setup_file <- create_experiment(
    name = "Wolf Sheep Simple Model Analysis",
    repetitions = 10,
    sequential_run_order = TRUE,
    run_metrics_every_step = TRUE,
    setup = "setup",
    go = "go",
    time_limit = 1000,
    metrics = c(
      'count wolves',
      'count sheep'
    ),
    run_metrics_condition = NULL,
    constants = list(
      "number-of-sheep" = 500,
      "number-of-wolves" = list(
        first = 5,
        step = 1,
        last = 15
      ),
      "movement-cost" = 0.5,
      "grass-regrowth-rate" = 0.3,
      "energy-gain-from-grass" = 2,
      "energy-gain-from-sheep" = 5
    )
  )

  run_experiment(
    netlogo_path = netlogo_path,
    model_path = model_path,
    setup_file = setup_file
  )
  ## Expected output:
  #> # A tibble: 110,110 × 10
  #>   run_number number_of_sheep number_of_wolves movement_cost
  #>         <dbl>           <dbl>            <dbl>         <dbl>
  #>  1          3             500                5           0.5
  #>  2          9             500                5           0.5
  #>  3          4             500                5           0.5
  #>  4          1             500                5           0.5
  #>  5          6             500                5           0.5
  #>  6          8             500                5           0.5
  #>  7          7             500                5           0.5
  #>  8          2             500                5           0.5
  #>  9          5             500                5           0.5
  #> 10          2             500                5           0.5
  #>  # 110,100 more rows
  #>  # 6 more variables: grass_regrowth_rate <dbl>,
  #>  # energy_gain_from_grass <dbl>, energy_gain_from_sheep <dbl>,
  #>  # step <dbl>, count_wolves <dbl>, count_sheep <dbl>
  #>  # Use `print(n = ...)` to see more rows
}

# Using an Experiment Defined in the NetLogo Model File -----

\dontrun{
  run_experiment(
    netlogo_path = netlogo_path,
    model_path = model_path,
    experiment = "Wolf Sheep Simple model analysis"
  )
  ## Expected output:
  #> # A tibble: 110 × 11
  #>    run_number energy_gain_from_grass number_of_wolves movement_cost
  #>         <dbl>                  <dbl>            <dbl>         <dbl>
  #>  1          4                      2                5           0.5
  #>  2          8                      2                5           0.5
  #>  3          2                      2                5           0.5
  #>  4          9                      2                5           0.5
  #>  5          1                      2                5           0.5
  #>  6          5                      2                5           0.5
  #>  7          7                      2                5           0.5
  #>  8          3                      2                5           0.5
  #>  9          6                      2                5           0.5
  #> 10         12                      2                6           0.5
  #> # 100 more rows
  #> # 7 more variables: energy_gain_from_sheep <dbl>,
  #> # number_of_sheep <dbl>, grass_regrowth_rate <dbl>, step <dbl>,
  #> # count_wolves <dbl>, count_sheep <dbl>,
  #> # sum_grass_amount_of_patches <dbl>
  #> # Use `print(n = ...)` to see more rows
}
}
\seealso{
Other NetLogo functions: 
\code{\link{create_experiment}()}
}
\concept{NetLogo functions}
