% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{bandwidth_optim}
\alias{bandwidth_optim}
\title{Bandwidth optimization for symmetric matrix kernels}
\usage{
bandwidth_optim(
  x,
  criterion = c("lscv", "lcv"),
  kernel = c("Wishart", "smlnorm", "smnorm"),
  tol = 1e-04,
  h = 1L
)
}
\arguments{
\item{x}{sample of symmetric matrix observations from which to build the kernel density kernel}

\item{criterion}{optimization criterion, one of \code{lscv} for least square cross-validation at lag \code{h} or \code{lcv} for leave-one-out cross-validation.}

\item{kernel}{string, one of \code{Wishart}, \code{smlnorm} (log-Gaussian) or \code{smnorm} (Gaussian).}

\item{tol}{double, tolerance of optimization (root search)}

\item{h}{lag step for consideration of observations, for the case \code{criterion=lscv}}
}
\value{
double, the optimal bandwidth up to \code{tol}
}
\description{
Given a sample of positive definite matrices,
perform numerical maximization of the \code{h}-block least square (\code{lscv}) or leave-one-out likelihood (\code{lcv}) cross-validation criteria using a root search.
}
