% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{asymmetrytest}
\alias{asymmetrytest}
\title{Wald tests for asymmetries}
\usage{
asymmetrytest(model)
}
\arguments{
\item{model}{The kardl obejct}
}
\value{
A list with class "kardl" containing the following components:
\itemize{
\item \code{Lhypotheses:} A list containing the null and alternative hypotheses for the long-run variables.
 \item \code{Lwald:} A data frame containing the Wald test results for the long-run variables, including F-statistic, p-value, degrees of freedom, and residual degrees of freedom.
 \item \code{Shypotheses:} A list containing the null and alternative hypotheses for the short-run variables.
 \item \code{Swald:} A data frame containing the Wald test results for the short-run variables, including F-statistic, p-value, degrees of freedom, residual degrees of freedom, and sum of squares.
 \item \code{type:} The type of the test, which is "asymmetrytest".
 }
}
\description{
The asymmetry test is a statistical procedure used to assess the presence of asymmetry in the relationship between variables in a model. It is particularly useful in econometric analysis, where it helps to identify whether the effects of changes in one variable on another are symmetric or asymmetric. The test involves estimating a model that includes both positive and negative components of the variables and then performing a Wald test to determine if the coefficients of these components are significantly different from each other. If the test indicates significant differences, it suggests that the relationship is asymmetric, meaning that the impact of increases and decreases in the variables differs.

The non-linear model with one asymmetric variables is specified as follows:
\deqn{
 \Delta{y_{t}} = \psi + \eta_{0}y_{t - 1} + \eta^{+}_{1} x^{+}_{t - 1}+ \eta^{-}_{1} x^{-}_{t - 1} + \sum_{j = 1}^{p}{\gamma_{j}\Delta y_{t - j}} + \sum_{j = 0}^{q}{\beta^{+}_{j}\Delta x^{+}_{t - j}}  + \sum_{j = 0}^{m}{\beta^{-}_{j}\Delta x^{-}_{t - j}} + e_{t}
}

This function performs the asymmetry test both for long-run and short-run variables in a kardl model. It uses the \code{\link[nlWaldTest]{nlWaldtest}} function from the \pkg{nlWaldTest} package for long-run variables and the \code{\link[car]{linearHypothesis}} function from the \pkg{car} package for short-run variables.
The hypotheses for the long-run variables are:
\deqn{
    H_{0}: -\frac{\eta^{+}_{1}}{\eta_{0}} = -\frac{\eta^{-}_{1}}{\eta_{0}} }
\deqn{    H_{1}: -\frac{\eta^{+}_{1}}{\eta_{0}} \neq -\frac{\eta^{-}_{1}}{\eta_{0}}
 }

 The hypotheses for the short-run variables are:
  \deqn{
  H_{0}: \sum_{j = 0}^{q}{\beta^{+}_{j}} = \sum_{j = 0}^{m}{\beta^{-}_{j}} }
  \deqn{H_{1}: \sum_{j = 0}^{q}{\beta^{+}_{j}} \neq \sum_{j = 0}^{m}{\beta^{-}_{j}}
  }
}
\details{
This function performs a Wald test to assess the validity of linearity or symmetry in both the short-run and long-run.

This function evaluates whether the inclusion of a particular variable in the model follows a linear relationship or exhibits a non-linear pattern. By analyzing the behavior of the variable, the function helps to identify if the relationship between the variable and the outcome of interest adheres to a straight-line assumption or if it deviates, indicating a non-linear interaction. This distinction is important in model specification, as it ensures that the variable is appropriately represented, which can enhance the model's accuracy and predictive performance.
}
\examples{


 kardl_model<-kardl(imf_example_data,
                    CPI~ER+PPI+asym(ER+PPI)+deterministic(covid)+trend,
                    mode=c(1,2,3,0,1))
 ast<- asymmetrytest(kardl_model)
 ast
 ast$Lhypotheses

 # Using magrittr package
 library(magrittr)
 imf_example_data \%>\% kardl(CPI~ER+PPI+asym(ER+PPI)+deterministic(covid)+trend,
                    mode=c(1,2,3,0,1)) \%>\% asymmetrytest()

 # Detailed results of the test:

 summary(ast)
 #Or, utilizing magrittr package
 imf_example_data \%>\% kardl(CPI~ER+PPI+asym(ER+PPI)+deterministic(covid)+trend,
                    mode=c(1,2,3,0,1)) \%>\% asymmetrytest() \%>\% summary()

}
\references{
Shin, Y., Yu, B., & Greenwood-Nimmo, M. (2014). Modelling asymmetric cointegration and dynamic multipliers in a nonlinear ARDL framework. Festschrift in honor of Peter Schmidt: Econometric methods and applications, 281-314.
}
\seealso{
\code{\link{kardl}}, \code{\link{pssf}}, \code{\link{psst}}, \code{\link{banerjee}}, \code{\link{recmt}}, \code{\link{narayan}}
}
