% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vectors.R
\name{fround_metric_lancet}
\alias{fround_metric_lancet}
\title{Format and round with data-type suffix}
\usage{
fround_metric_lancet(
  x,
  metric = "prop",
  digits = 1L,
  nsmall = 1L,
  decimal.mark = mid_dot()
)
}
\arguments{
\item{x}{[num] numeric value}

\item{metric}{[chr: default 'prop' c('prop', 'pp', 'count', rate)]}

\item{digits}{[integer: default 1L] passed to `round()`}

\item{nsmall}{[integer: default 1L] passed to `format()`}

\item{decimal.mark}{[chr: default mid_dot()] decimal mark passed to `format()`}
}
\value{
[chr] formatted string
}
\description{
Lancet-specific wrapper for `fround_metric()`, using mid-dot as decimal mark.
Retaining for legacy purposes (no Nature equivalent)
}
\examples{
fround_metric_lancet(0.123456789)
fround_metric_lancet(0.123456789, 'pp', 3, 4)
fround_metric_lancet(c(55.8346, 123.456789), 'count', 3, 4, ".")
}
\seealso{
Other vector_formats: 
\code{\link{add_epsilon}()},
\code{\link{fmt_magnitude}()},
\code{\link{format_oxford_comma}()},
\code{\link{fround}()},
\code{\link{fround_count_rate}()},
\code{\link{fround_metric}()},
\code{\link{fround_props}()}
}
\concept{vector_formats}
