% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{plot_diff}
\alias{plot_diff}
\alias{plotDiff}
\title{Plot difference curve based on model predictions.}
\usage{
plot_diff(
  model,
  view,
  comp,
  cond = NULL,
  se = 1.96,
  sim.ci = FALSE,
  n.grid = 100,
  add = FALSE,
  rm.ranef = TRUE,
  mark.diff = TRUE,
  col.diff = "red",
  col = "black",
  eegAxis = FALSE,
  transform.view = NULL,
  print.summary = getOption("itsadug_print"),
  plot = TRUE,
  main = NULL,
  ylab = NULL,
  xlab = NULL,
  xlim = NULL,
  ylim = NULL,
  hide.label = FALSE,
  ...
)
}
\arguments{
\item{model}{A GAMM model, resulting from the functions
\code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.}

\item{view}{Name of continuous predictor that should be plotted on the x-
axis.}

\item{comp}{Named list with the grouping predictor (categorical variable)
and the 2 levels to calculate the difference for.}

\item{cond}{A named list of the values to use for the predictor terms. 
Variables omitted from this list will have the closest observed value to 
the median for continuous variables, or the reference level for factors.}

\item{se}{If less than or equal to zero then only the predicted smooth is 
plotted, but if greater than zero, then the predicted values plus 
confidence intervals are plotted. 
The value of \code{se} will be multiplied with 
the standard error (i.e., 1.96 results in 95\%CI and 2.58). 
Default is set to 1.96 (95\%CI).}

\item{sim.ci}{Logical: Using simultaneous confidence intervals or not 
(default set to FALSE). The implementation of simultaneous CIs follows 
Gavin Simpson's blog of December 15, 2016: 
\url{https://fromthebottomoftheheap.net/2016/12/15/simultaneous-interval-revisited/}. 
This interval is calculated from simulations based. 
Please specify a seed (e.g., \code{set.seed(123)}) for reproducable results. 
Note: in contrast with Gavin Simpson's code, here the Bayesian posterior 
covariance matrix of the parameters is uncertainty corrected 
(\code{unconditional=TRUE}) to reflect the uncertainty on the estimation of 
smoothness parameters.}

\item{n.grid}{Number of data points sampled as predictions. Defaults to 100.}

\item{add}{Logical: whether or not to add the line to an existing plot. 
Default is FALSE.
When no plot window is available and \code{add=TRUE}, 
the function will generate an error.}

\item{rm.ranef}{Logical: whether or not to remove random effects. 
Default is TRUE. Alternatively a string (or vector of strings) with the 
name of the random effect(s) to remove.}

\item{mark.diff}{Logical: whether or not marking where the difference 
is significantly different from 0.}

\item{col.diff}{Color to mark differences (red by default).}

\item{col}{Line color. Shading color is derived from line color.}

\item{eegAxis}{Logical: whether or not to reverse the y-axis, plotting 
negative values upwards. Default is FALSE.}

\item{transform.view}{Function for transforming 
the values on the x-axis. Defaults to NULL (no transformation). 
(See \code{\link{plot_smooth}} for more info.)}

\item{print.summary}{Logical: whether or not to print the summary. 
Default set to the print info messages option 
(see \code{\link{infoMessages}}).}

\item{plot}{Logical: whether or not to plot the difference. If FALSE, then 
the output is returned as a list, with the estimated difference 
(\code{est}) and the standard error over the estimate (\code{se.est}) and 
the x-values (\code{x}). Default is TRUE.}

\item{main}{Text string, alternative title for plot.}

\item{ylab}{Text string, alternative label for y-axis.}

\item{xlab}{Text string, alternative label for x-axis.}

\item{xlim}{Range of x-axis. If not specified, the function automatically 
generates an appropriate x-axis.}

\item{ylim}{Range of y-axis. If not specified, the function automatically 
generates an appropriate y-axis.}

\item{hide.label}{Logical: whether or not to hide the label 
(i.e., 'difference'). Default is FALSE.}

\item{...}{Optional arguments for \code{\link[plotfunctions]{emptyPlot}}, 
or \code{\link[plotfunctions]{plot_error}}.}
}
\value{
If the result is not being plotted, a list is 
returned with the estimated difference (\code{est}) and the standard error 
over the estimate (\code{se}) and the x-values (\code{x}) is returned.
}
\description{
Plot difference curve based on model predictions.
}
\examples{
data(simdat)
\dontrun{
m1 <- bam(Y ~ Group + te(Time, Trial, by=Group)
    + s(Time, Subject, bs='fs', m=1),
    data=simdat, discrete=TRUE)
plot_diff(m1, view='Time', comp=list(Group=c('Children', 'Adults')))
# in this model, excluding random effects does not change the difference:
plot_diff(m1, view='Time', comp=list(Group=c('Children', 'Adults')), 
    rm.ranef=TRUE)
# simultaneous CI:
plot_diff(m1, view='Time', comp=list(Group=c('Children', 'Adults')), 
    rm.ranef=TRUE, sim.ci=TRUE)
# Reversed y-axis (for EEG data) and no shading:
plot_diff(m1, view='Time', comp=list(Group=c('Children', 'Adults')), 
    eegAxis=TRUE, shade=FALSE)
plot_diff(m1, view='Time', comp=list(Group=c('Children', 'Adults')),
density=15, angle=90, ci.lwd=3)
# Retrieving plot values...
out <- plot_diff(m1, view='Time', comp=list(Group=c('Children', 'Adults')), 
   plot=FALSE)
#... which might be used for indicating differences:
x <- find_difference(out$est, out$se, f=1.96, xVals=out$xVals)
# add lines:
arrows(x0=x$start, x1=x$end, y0=0, y1=0,code=3, length=.1, col='red')
}

}
\seealso{
Other Testing for significance: 
\code{\link{compareML}()},
\code{\link{plot_diff2}()},
\code{\link{report_stats}()},
\code{\link{wald_gam}()}
}
\author{
Martijn Wieling, Jacolien van Rij
}
\concept{Testing for significance}
