% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{inline_text}
\alias{inline_text}
\title{Inline text input}
\usage{
inline_text(id, value = "", placeholder = "Enter text", meaning = NULL)
}
\arguments{
\item{id}{The \code{input} slot that will be used to access the value.}

\item{value}{The initial text contents (a character string).}

\item{placeholder}{The character string or HTML element that will appear in
the textbox when it is empty, as a prompt.}

\item{meaning}{A descriptive label, for people using assistive technology
such as screen readers.}
}
\value{
An inline widget to be included in an \code{\link[=inline]{inline()}} wrapper.
}
\description{
A single line text input similar to \code{\link[shiny:textInput]{shiny::textInput()}} that can be
included in an \code{\link[=inline]{inline()}} wrapper.
}
\examples{
ui <- bslib::page_fixed(
    shiny::h1("Hello!"),
    inline("My name is ", inline_text("myname", "Sisyphus",
        placeholder = "Enter your name", meaning = "Your name"), ".")
)
}
\seealso{
\link[shiny:textInput]{shiny::textInput} for how the text input works with your Shiny server.
}
