% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline.R
\name{inline}
\alias{inline}
\title{Container for inline widgets}
\usage{
inline(..., class = "mb-1")
}
\arguments{
\item{...}{Unnamed arguments: Inline widgets (such as \code{\link[=inline_text]{inline_text()}}),
character strings, or \link[htmltools:builder]{HTML tags} that will appear next
to each other in a line or paragraph. These are pasted together with no
spaces between them, so add extra spaces to your character strings if
needed. Named arguments (e.g. \code{style}) are additional attributes for the
HTML \link[htmltools:builder]{div} tag wrapping the line.}

\item{class}{Extra classes to apply to the line. The default, \code{"mb-1"}, is a
Bootstrap 5 class that adds a small amount of margin to the bottom of
the line. You can use \code{"mb-0"} through \code{"mb-5"}, other
\href{https://getbootstrap.com/docs/5.3/utilities/spacing/}{Bootstrap 5 spacing classes},
or anything else. For multiple classes, provide one space-separated
string.}
}
\value{
An HTML element to be included in your Shiny UI definition.
}
\description{
Wrapper for a line (or paragraph) containing a mix of explanatory text and
inshiny inline widgets.
}
\examples{
ui <- bslib::page_fixed(
    shiny::h1("Hello!"),
    inline("My name is ", inline_text("myname", "Sisyphus"), "."),
    inline("Please enter your name carefully.", style = "font-weight:bold")
)
}
