% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_burden.R
\name{calc_burden}
\alias{calc_burden}
\title{Calculate case burden rate}
\usage{
calc_burden(
  injd,
  by = NULL,
  overall = TRUE,
  method = c("poisson", "negbin", "zinfpois", "zinfnb"),
  se = TRUE,
  conf_level = 0.95,
  scale = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{injd}{\code{injd} \strong{S3} object (see
\code{\link[=prepare_all]{prepare_all()}}).}

\item{by}{Character specifying the name of the column according to which
compute summary statistics. It should refer to a (categorical) variable
that describes a grouping factor (e.g. "type of case or injury", "injury
location", "sports club"). Optional, defaults to \code{NULL}.}

\item{overall}{Logical, whether to calculate overall (for all the cohort) or
athlete-wise summary statistic (i.e. number of cases per cohort of per
athlete). Defaults to \code{TRUE}.}

\item{method}{Method to estimate the incidence (burden) rate. One of
"poisson", "negbin", "zinfpois" or "zinfnb"; that stand for Poisson method,
negative binomial method, zero-inflated Poisson and zero-inflated negative
binomial.}

\item{se}{Logical, whether to calculate the confidence interval related to
the rate.}

\item{conf_level}{Confidence level (defaults to 0.95).}

\item{scale}{Logical, whether to transform the incidence and burden rates
output according to the unit of exposure (defaults to \code{TRUE}).}

\item{quiet}{Logical, whether or not to silence the warning messages
(defaults to \code{FALSE}).}
}
\value{
The case burden rate. Either a numeric value (if overall
\code{TRUE}) or a data frame indicating the case burden rate per
athlete.
}
\description{
Calculate the case burden rate of a sports-related health problem (e.g.
disease, injury) in a cohort.
}
\examples{
calc_burden(injd)
calc_burden(injd, overall = FALSE)
calc_burden(injd, by = "injury_type")
}
\references{
Bahr R., Clarsen B., & Ekstrand J. (2018). Why we should focus on the burden
of injuries and illnesses, not just their incidence. \emph{British Journal of
Sports Medicine}, 52(16), 1018–1021.
\doi{10.1136/bjsports-2017-098160}

Waldén M., Mountjoy M., McCall A., Serner A., Massey A., Tol J. L.,
... & Andersen T. E. (2023). Football-specific extension of the IOC
consensus statement: methods for recording and reporting of epidemiological
data on injury and illness in sport 2020. \emph{British journal of sports
medicine}.
}
