% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_coefficient}
\alias{plot_coefficient}
\title{Plot coefficients}
\usage{
plot_coefficient(
  data,
  style = "continuous",
  positive_color = "#3d67a2",
  negative_color = "#c82926",
  neutral_color = "#cccccc",
  bar_width = 0.7,
  text_size = 3,
  show_values = TRUE
)
}
\arguments{
\item{data}{Input data.}

\item{style}{Plotting style: \code{"binary"}, \code{"gradient"}, or \code{"continuous"}.}

\item{positive_color}{Color for positive weights.
Default is \code{"#3d67a2"}.}

\item{negative_color}{Color for negative weights.
Default is \code{"#c82926"}.}

\item{neutral_color}{Color for weights near zero (used in \code{"continuous"} style).
Default is \code{"#cccccc"}.}

\item{bar_width}{Width of the bars.
Default is \code{0.7}.}

\item{text_size}{Size of the text for weight values.
Default is \code{3}.}

\item{show_values}{Whether to show weight values on bars.
Default is \code{TRUE}.}
}
\value{
A ggplot object
}
\description{
Plot coefficients
}
\examples{
data(example_matrix)
network_table <- inferCSN(example_matrix, targets = "g1")
plot_coefficient(network_table)
plot_coefficient(network_table, style = "binary")
}
