% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_covid_stats_by_continent.R
\name{get_covid_stats_by_continent}
\alias{get_covid_stats_by_continent}
\title{Get COVID-19 Statistics for All Continents}
\usage{
get_covid_stats_by_continent(
  yesterday = FALSE,
  twoDaysAgo = FALSE,
  sort = NULL,
  allowNull = FALSE
)
}
\arguments{
\item{yesterday}{Logical. If \code{TRUE}, retrieves data reported from the previous day. Default is \code{FALSE}.}

\item{twoDaysAgo}{Logical. If \code{TRUE}, retrieves data reported two days ago. Default is \code{FALSE}.}

\item{sort}{Character. Field to sort results by. Options include: \code{"cases"}, \code{"todayCases"}, \code{"deaths"}, \code{"recovered"}, \code{"active"}, etc.}

\item{allowNull}{Logical. If \code{TRUE}, missing values are returned as \code{NA} instead of \code{0}. Default is \code{FALSE}.}
}
\value{
A data frame containing:
\itemize{
  \item \code{continent}: Continent name.
  \item \code{updated}: Last updated timestamp (as POSIXct in UTC).
  \item \code{cases}: Total confirmed cases.
  \item \code{todayCases}: New confirmed cases today.
  \item \code{deaths}: Total deaths.
  \item \code{todayDeaths}: New deaths today.
  \item \code{population}: Continent population estimate.
}
Returns \code{NULL} if the API is unavailable or an error occurs.
}
\description{
Retrieves real-time COVID-19 totals for all continents from the 'disease.sh' API.
}
\details{
This function retrieves COVID-19 summary data for each continent.
You may specify whether to get data from today, yesterday, or two days ago.
Requires an active internet connection.
}
\note{
Requires internet access. Function fails gracefully if API is unavailable.
}
\examples{
\dontrun{
# Get current COVID-19 stats for all continents
stats <- get_covid_stats_by_continent()
if (!is.null(stats)) {
  print(stats)
}

# Get yesterday's data sorted by number of cases
stats_yesterday <- get_covid_stats_by_continent(yesterday = TRUE, sort = "cases")
}

}
\references{
API Docs: https://disease.sh/docs/#/COVID-19%3A%20Worldometers/get_v3_covid_19_continents
}
