% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cimg_class.R
\name{plot.cimg}
\alias{plot.cimg}
\title{Display an image using base graphics}
\usage{
\method{plot}{cimg}(
  x,
  frame,
  xlim = c(1, width(x)),
  ylim = c(height(x), 1),
  xlab = "x",
  ylab = "y",
  rescale = TRUE,
  colourscale = NULL,
  colorscale = NULL,
  interpolate = TRUE,
  axes = TRUE,
  main = "",
  xaxs = "i",
  yaxs = "i",
  asp = 1,
  col.na = rgb(0, 0, 0, 0),
  ...
)
}
\arguments{
\item{x}{the image}

\item{frame}{which frame to display, if the image has depth > 1}

\item{xlim}{x plot limits (default: 1 to width)}

\item{ylim}{y plot limits (default: 1 to height)}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{rescale}{rescale pixel values so that their range is [0,1]}

\item{colourscale, colorscale}{an optional colour scale (default is gray or rgb)}

\item{interpolate}{should the image be plotted with antialiasing (default TRUE)}

\item{axes}{Whether to draw axes (default TRUE)}

\item{main}{Main title}

\item{xaxs}{The style of axis interval calculation to be used for the x-axis. See ?par}

\item{yaxs}{The style of axis interval calculation to be used for the y-axis. See ?par}

\item{asp}{aspect ratio. The default value (1) means that the aspect ratio of the image will be kept regardless of the dimensions of the plot. A numeric value other than one changes the aspect ratio, but it will be kept the same regardless of dimensions. Setting asp="varying" means the aspect ratio will depend on plot dimensions (this used to be the default in versions of imager < 0.40)}

\item{col.na}{which colour to use for NA values, as R rgb code. The default is "rgb(0,0,0,0)", which corresponds to a fully transparent colour.}

\item{...}{other parameters to be passed to plot.default (eg "main")}
}
\description{
If you want to control precisely how numerical values are turned into colours for plotting, you need to specify a colour scale using the colourscale argument (see examples). Otherwise the default is "gray" for grayscale images, "rgb" for colour. These expect values in [0..1], so the default is to rescale the data to [0..1]. If you wish to over-ride that behaviour, set rescale=FALSE.
See examples for an explanation.
If the image is one dimensional (i.e., a simple row or column image), then pixel values will be plotted as a line.
}
\examples{
\dontshow{cimg.limit.openmp()}
plot(boats,main="Boats")
plot(boats,axes=FALSE,xlab="",ylab="")

#Pixel values are rescaled to 0-1 by default, so that the following two plots are identical
plot(boats)
plot(boats/2,main="Rescaled")
#If you don't want that behaviour, you can set rescale to FALSE, but
#then you need to make sure values are in [0,1]
try(plot(boats,rescale=FALSE)) #Error!
try(plot(boats/255,rescale=FALSE)) #Works
#You can specify a colour scale if you don't want the default one.
#A colour scale is a function that takes pixels values and return an RGB code,
#like R's rgb function,e.g.
rgb(0,1,0)
#Let's switch colour channels
cscale <- function(r,g,b) rgb(b,g,r)
plot(boats/255,rescale=FALSE,colourscale=cscale)
#Display slice of HSV colour space
im <- imfill(255,255,val=1)
im <- list(Xc(im)/255,Yc(im)/255,im) \%>\% imappend("c")
plot(im,colourscale=hsv,rescale=FALSE,
     xlab="Hue",ylab="Saturation")
#In grayscale images, the colourscale function should take in a single value
#and return an RGB code
boats.gs <- grayscale(boats)
#We use an interpolation function from package scales
cscale <- scales::gradient_n_pal(c("red","purple","lightblue"),c(0,.5,1))
plot(boats.gs,rescale=FALSE,colourscale=cscale)
#Plot a one-dimensional image
imsub(boats,x==1) \%>\% plot(main="Image values along first column")
#Plotting with and without anti-aliasing:
boats.small <- imresize(boats,.3)
plot(boats.small,interp=TRUE)
plot(boats.small,interp=FALSE)
}
\seealso{
display, which is much faster, as.raster, which converts images to R raster objects
}
