% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_zip_images_by_class.R
\name{ifcb_zip_images_by_class}
\alias{ifcb_zip_images_by_class}
\title{Zip Image Subfolders by Class}
\usage{
ifcb_zip_images_by_class(
  image_folder,
  output_dir,
  n_images = NULL,
  quiet = FALSE
)
}
\arguments{
\item{image_folder}{The directory containing subdirectories with image files.}

\item{output_dir}{The directory where the zip archives will be written.}

\item{n_images}{Integer. Maximum number of images to randomly sample per
subdirectory. If NULL, all images are included.}

\item{quiet}{Logical. If TRUE, suppresses the progress bar. Default is FALSE.}
}
\value{
This function does not return any value; it creates one zip archive per
subdirectory containing images.
}
\description{
This function creates one zip archive per immediate subdirectory in a folder
containing image files. Each archive corresponds to a single class or taxon.
}
\details{
When \code{n_images} is specified, images are randomly sampled without replacement
from each subdirectory. When \code{n_images} is NULL, all images in each subdirectory
are included.

Supported image formats (case-insensitive) are:
\code{png}, \code{jpg}, \code{jpeg}, \code{tif}, \code{tiff}, \code{bmp}, and \code{gif}.
}
\examples{
\dontrun{
# Set a random seed to reproduce the random sampling
set.seed(123)

# Create zip archives for each subdirectory with up to 50 random images
ifcb_zip_images_by_class(
  image_folder = "path/to/images",
  output_dir = "path/to/zips",
  n_images = 50
)
}
}
