% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_phase.R
\name{phase}
\alias{phase}
\title{Computing phased time series}
\usage{
phase(x, ...)
}
\arguments{
\item{x}{An object of class `utilities`.}

\item{...}{Additional arguments for pairing time series:
\describe{
  \item{data}{A data frame with three columns corresponding to the time, values, and standard errors of the irregularly observed time series.}
  \item{f1}{frequency (1 / period) of the time series.}
  \item{twop}{logical; if TRUE, the phased series will be duplicated over two cycles (0–2).}
 }}
}
\value{
An object of class `utilities` with the slots:
\item{series_phased}{A numeric vector containing the time series values ordered by phase.}
\item{series_esd_phased}{A numeric vector containing the error standard deviations of the time series ordered by phase.}
\item{times_phased}{A numeric vector of phased times (values between 0 and 1, or 0 and 2 if 'two.cycles = TRUE').}
}
\description{
This function computes a time series folded on its period.
}
\details{
The phase \eqn{\phi} of an observation is computed as
\deqn{\phi = \frac{t - t_0}{p} - \mathrm{E}(t),}
where \eqn{t_0} is the reference time (by default the first observation),
\eqn{p = 1/f_1} is the period, and \eqn{\mathrm{E}(t)} is the integer part of
\eqn{(t - t_0)/p}.
}
\examples{
data(clcep)
f1=0.060033386
o1=iAR::utilities()
o1<-phase(o1,data=clcep,f1=f1,twop=TRUE)
plot(o1@times_phased,o1@series_phased,pch=20)
}
\references{
\insertRef{Elorrieta_2021}{iAR}
}
