% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_divergence.R
\name{add_divergence}
\alias{add_divergence}
\alias{add_divergence.data.frame}
\alias{add_divergence.hy}
\title{Add Divergence Attribute}
\usage{
add_divergence(
  x,
  coastal_outlet_ids,
  inland_outlet_ids,
  name_attr,
  type_attr,
  major_types
)

\method{add_divergence}{data.frame}(
  x,
  coastal_outlet_ids,
  inland_outlet_ids,
  name_attr,
  type_attr,
  major_types
)

\method{add_divergence}{hy}(
  x,
  coastal_outlet_ids,
  inland_outlet_ids,
  name_attr,
  type_attr,
  major_types
)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{coastal_outlet_ids}{vector of identifiers for network outlets that
terminate at the coast.}

\item{inland_outlet_ids}{vector of identifiers for network outlets that
terminate inland.}

\item{name_attr}{character attribute name of attribute containing a feature
name or name identifier.}

\item{type_attr}{character attribute name of attribute containing a feature
type indicator.}

\item{major_types}{vector of values of \code{type_attr} that should be interpreted
as being "major". e.g. river might be major and canal might be minor.}
}
\value{
returns x with a \code{divergence} attribute appended
}
\description{
Given a non-dendritic flow network and required attributes,
adds a divergence attribute according to NHDPlus data model methods.
}
\details{
When considering downstream connections with diversions, there are three
factors considered to determine which is primary.\if{html}{\out{<br>}}
1a) same name\if{html}{\out{<br>}}
1b) is named\if{html}{\out{<br>}}
2) feature type (type_attr controls this)\if{html}{\out{<br>}}
3) flows to coast (has a coastal connection is preferred)\if{html}{\out{<br>}}

The following list describes the order of precedence for tests\if{html}{\out{<br>}}
1: 1a, 2, 3\if{html}{\out{<br>}}
2: 1a, 2\if{html}{\out{<br>}}
3: The NHDPlus uses diverted fraction this is not used currently.\if{html}{\out{<br>}}
4: 1b, 2, 3\if{html}{\out{<br>}}
5: 2, 3\if{html}{\out{<br>}}
6: 1b, 3\if{html}{\out{<br>}}
7: 3,\if{html}{\out{<br>}}
8: 1b, 2\if{html}{\out{<br>}}
9: 2\if{html}{\out{<br>}}
10: 1b\if{html}{\out{<br>}}

If all checks return and no primary connection has been identified, the
connection with a smaller id is chosen.

In the case that there are two or more upstream connections, the upstream
name to use is chosen 1) if there is only one upstream flowline with a name
2) if one of the upstream flowlines with a name matches the downstream line,
3) if one of the upstream flowlines is of a "major" type and others are not,
and, 4) if no criteria exist to select one, the smallest id value otherwise.
}
\examples{

f <- system.file("extdata/coastal_example.gpkg", package = "hydroloom")

g <- sf::read_sf(f)
g <- g[g$FTYPE != "Coastline", ]

outlets <- g$COMID[!g$ToNode \%in\% g$FromNode]

g <- dplyr::select(g, COMID, gnis_id, FTYPE,
                   FromNode, ToNode)

add_divergence(g,
               coastal_outlet_ids = outlets,
               inland_outlet_ids = c(),
               name_attr = "gnis_id",
               type_attr = "FTYPE",
               major_types = c("StreamRiver", "ArtificialPath", "Connector"))


}
