% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametise.R
\name{H2_Piepho_parameters}
\alias{H2_Piepho_parameters}
\title{Calculate Piepho's heritability using variance parameters}
\usage{
H2_Piepho_parameters(vc_g, vd_BLUE_avg)
}
\arguments{
\item{vc_g}{Numeric. Genotype variance component}

\item{vd_BLUE_avg}{Numeric. Mean variance of pairwise differences among BLUES}
}
\value{
Numeric value
}
\description{
Compute Piepho's heritability using the variance of differences between two BLUES.
}
\details{
The equation for Piepho's heritability is as follows:

\deqn{H^2_{Piepho} = \frac{\sigma^2_g}{\sigma^2_g + \overline{PEV_{BLUE_g}} / 2}}

where:
\itemize{
\item \eqn{\overline{PEV_{BLUE_g}}} is the prediction error variance matrix for genotype BLUEs
\item \eqn{\sigma^2_g} is the variance attributed to differences between genotype
}
}
\examples{
H2_Piepho_parameters(vc_g = 0.25, vd_BLUE_avg = 0.68)

}
\references{
Piepho, H.-P., & Möhring, J. (2007). Computing Heritability and Selection Response From Unbalanced Plant Breeding Trials. Genetics, 177(3), 1881–1888. https://doi.org/10.1534/genetics.107.074229
}
