% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inflation_factor.R
\name{get_inflation_factor}
\alias{get_inflation_factor}
\title{Get inflation factor}
\usage{
get_inflation_factor(n_years, inflation_rate = NULL)
}
\arguments{
\item{n_years}{\code{Numeric value} referring to number of years in the future to be considered in the discounting and/or inflation. Be aware that the year 0 (without discounting/inflation, i.e. the present) is not be counted here. If a vector is entered in the argument impact, n_years does not need to be entered (length of impact = n_years + 1).}

\item{inflation_rate}{\code{Numeric value} between 0 and 1 referring to the annual inflation (increase of prices). Only to be entered if nominal (not real) discount rate is entered in the function. Default value = NULL (assuming no nominal discount rate).}
}
\value{
This function returns the \code{numeric} inflation factor.
}
\description{
This function calculates the inflation factor based on inflation rate.
}
\details{
\strong{Equation inflation factor (without discounting)}

\deqn{inflation\_factor = (1 + inflation\_rate)^{n\_years}}
}
\examples{
get_inflation_factor(
  inflation_rate = 0.02,
  n_years = 5
)
}
\author{
Alberto Castro & Axel Luyten
}
