% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{npar_mixturecure}
\alias{npar_mixturecure}
\title{Number of parameters in fitted mixture cure model}
\usage{
npar_mixturecure(object, model_select = "AIC")
}
\arguments{
\item{object}{a \code{mixturecure} object resulting from \code{curegmifs},
\code{cureem}, \code{cv_curegmifs}, \code{cv_cureem}.}

\item{model_select}{either a case-sensitive parameter for models fit using
\code{curegmifs} or \code{cureem} or any numeric step along the solution path
can be selected. The default is \code{model_select = "AIC"} which calculates
the predicted values using the coefficients from the model achieving the
minimum AIC. The complete list of options are:
\itemize{
\item \code{"AIC"} for the minimum AIC (default).
\item \code{"mAIC"} for the minimum modified AIC.
\item \code{"cAIC"} for the minimum corrected AIC.
\item \code{"BIC"}, for the minimum BIC.
\item \code{"mBIC"} for the minimum modified BIC.
\item \code{"EBIC"} for the minimum extended BIC.
\item \code{"logLik"} for the step that maximizes the
log-likelihood.
\item \code{n} where n is any numeric value from the
solution path.
}
This option has no effect for objects fit using \code{cv_curegmifs} or
\code{cv_cureem}.}
}
\value{
number of paramaters of the fitted mixture cure model using the
specified criteria.
}
\description{
This function returns the number of parameters in a user-specified model
criterion or step for a \code{curegmifs}, \code{cureem},
\code{cv_curegmifs} or \code{cv_cureem} fitted object.
}
