% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{to_gif}
\alias{to_gif}
\title{Convert A Multi-layer Raster to GIF}
\usage{
to_gif(
  r,
  fps = 5,
  width = 600,
  height = 600,
  axes = TRUE,
  title_prefix = NULL,
  border = FALSE
)
}
\arguments{
\item{r}{SpatRaster or sf. A SpatRaster with multiple layers or an sf object
with multiple numeric value columns.}

\item{fps}{numeric. Frames per second (default 5).}

\item{width}{numeric. Width of output GIF in pixels.}

\item{height}{numeric. Height of output GIF in pixels.}

\item{axes}{logical. Draw axes?}

\item{title_prefix}{character or character vector.}

\item{border}{character. Color of polygon border(s); using NA hides them.
Only optional when \code{r} is an sf object.}
}
\value{
An animated magick image object (GIF).
}
\description{
Export a multi-layer raster (\code{SpatRaster}) or vector layer (\code{sf})
with multiple numeric value columns to an animated GIF.
}
\examples{
sample_data <- terra::rast(system.file("extdata", "detroit_gs.tif", package = "greenSD"))
gif <- to_gif(sample_data)

}
