% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Offset.R
\name{set_offset}
\alias{set_offset}
\alias{set_offsets}
\alias{the_MAX_N_OFFSETN}
\title{Set offsets}
\usage{
set_offset(
  offset_1st = integer(1),
  thresholds = integer(),
  tapers = double(),
  refundable = logical(1)
)

set_offsets(
  ...,
  yr = NULL,
  lito_max_offset = NULL,
  lito_taper = NULL,
  lito_min_bracket = NULL,
  lito_multi = NULL
)

the_MAX_N_OFFSETN()
}
\arguments{
\item{offset_1st}{\code{integer(1)} The offset available for zero income.}

\item{thresholds}{\code{integer(N)} An sorted integer vector, the thresholds
above which each taper applies.}

\item{tapers}{\code{double(N)} The tapers above each \code{threshold}. Positive
tapers mean that the offset reduces for every dollar above the corresponding
threshold.}

\item{refundable}{\code{bool(1)} If \code{FALSE}, the default, offsets are 
non-refundable, meaning that the offset cannot reduce the tax below zero.}

\item{...}{A set of offsets created by \code{set_offset}. May not exceed
\code{the_MAX_N_OFFSETN()}.}

\item{yr}{\code{NULL / integer(1)} If \code{NULL}, only the offsets created
by \code{...} are used. Otherwise, inherits offsets (such as LITO and LMITO)
from the corresponding year.}

\item{lito_max_offset, lito_taper, lito_min_bracket, lito_multi}{deprecated
arguments to adjust (single-threshold) LITO.}
}
\value{
\describe{
\item{\code{set_offset}}{A list of four elements, \code{offset_1st}, 
\code{thresholds}, \code{tapers}, \code{refundable}.}
\item{\code{set_offsets}}{A list of lists created by \code{set_offset}.}
\item{\code{the_MAX_N_OFFSETN}}{The maximum number of offsets that may be used.}
}
}
\description{
Create parameters for tax offsets.
}
