% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric_Wishart.R
\name{cgeneric_Wishart}
\alias{cgeneric_Wishart}
\title{Build an \code{cgeneric} to implement the Wishart
prior for a precision matrix.}
\usage{
cgeneric_Wishart(n, dof, R, debug = FALSE, useINLAprecomp = TRUE, shlib = NULL)
}
\arguments{
\item{n}{the size of the precision matrix}

\item{dof}{degrees of freedom model parameter}

\item{R}{lower triangle of the scale matrix parameter}

\item{debug}{integer, default is zero, indicating the verbose level.
Will be used as logical by INLA.}

\item{useINLAprecomp}{logical, default is TRUE, indicating if it is to
be used the shared object pre-compiled by INLA.
This is not considered if 'shlib' is provided.}

\item{shlib}{string, default is NULL, with the path to the shared object.}
}
\value{
a \code{cgeneric}, \code{\link[INLAtools:cgeneric-class]{INLAtools::cgeneric()}} object.
}
\description{
Build an \code{cgeneric} to implement the Wishart
prior for a precision matrix.
}
\details{
For a random \eqn{p\times p} precision matrix \eqn{Q},
given the parameters \eqn{d} and \eqn{R},
respectively scalar degree of freedom and the \emph{inverse}
scale \eqn{p\times p} matrix the Wishart density is
\deqn{|Q|^{(d-p-1)/2}\textrm{e}^{-tr(RQ)/2}|R|^{p/2}2^{-dp/2}\Gamma_p(n/2)^{-1}}
}
