% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{gl_auth}
\alias{gl_auth}
\alias{gl_auto_auth}
\title{Authenticate with Google Language API services}
\usage{
gl_auth(json_file)

gl_auto_auth(...)
}
\arguments{
\item{json_file}{Character. Path to the JSON authentication file downloaded from your Google Cloud project.}

\item{...}{Additional arguments passed to \code{gar_attach_auto_auth}.}
}
\description{
Authenticate with Google Language API services
}
\details{
This function authenticates with Google Cloud's language APIs. By default, it uses the JSON file specified
in \code{json_file}. Alternatively, you can set the file path in the environment variable \code{GL_AUTH} to
auto-authenticate when loading the package.
}
\examples{
\dontrun{
library(googleLanguageR)
gl_auth("path/to/json_file.json")
}
\dontrun{
library(googleLanguageR)
gl_auto_auth()
gl_auto_auth(environment_var = "GAR_AUTH_FILE")
}
}
