% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrations.R
\name{publish}
\alias{publish}
\title{Publishes a figure to the GoFigr service.}
\usage{
publish(
  plot_obj,
  figure_name = NULL,
  input_path = NULL,
  input_contents = NULL,
  chunk_code = NULL,
  image_formats = c("eps"),
  data = NULL,
  metadata = NULL,
  show = TRUE,
  base_convert = TRUE,
  width = NULL,
  height = NULL,
  units = "in",
  dpi = NULL
)
}
\arguments{
\item{plot_obj}{plot to publish}

\item{figure_name}{name of the figure. If NULL, it will be inferred from the figure's title}

\item{input_path}{path to the source file}

\item{input_contents}{contents of the source file}

\item{chunk_code}{chunk code, if running R markdown}

\item{image_formats}{image formats to save}

\item{data}{optional data to save with this figure. The data will be saved as RDS.}

\item{metadata}{optional metadata}

\item{show}{whether to display the figure after publication}

\item{base_convert}{whether to try converting base graphics to grid graphics}

\item{width}{width of the output image. If NULL, uses current device dimensions.}

\item{height}{height of the output image. If NULL, uses current device dimensions.}

\item{units}{units for width and height. Default is "in" (inches). Other options include "cm", "mm", "px".}

\item{dpi}{resolution of the output image. If NULL, uses ggsave default (300).}
}
\value{
GoFigr revision object
}
\description{
Publishes a figure to the GoFigr service.
}
