% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-iupac-short.R
\name{parse_iupac_short}
\alias{parse_iupac_short}
\title{Parse IUPAC-short Structures}
\usage{
parse_iupac_short(x)
}
\arguments{
\item{x}{A character vector of IUPAC-short strings.}
}
\value{
A \code{\link[glyrepr:glycan_structure]{glyrepr::glycan_structure()}} object.
}
\description{
Parse IUPAC-short-style structure characters into a \code{\link[glyrepr:glycan_structure]{glyrepr::glycan_structure()}}.
For more information about IUPAC-short format, see \doi{10.1351/pac199668101919}.
}
\details{
The IUPAC-short notation is a compact form of IUPAC-condensed notation.
It is rarely used in database, but appears a lot in literature for its
conciseness. Compared with IUPAC-condensed notation, IUPAC-short notation
ignore the anomer positions, assuming they are known for common monosaccharides.
For example, "Neu5Aca3Gala-" assumes the anomer of Neu5Ac is C2 (a2-3 linked).
Also, the parentheses around linkages are omitted, and parentheses are used
to indicate branching, e.g. "Neu5Aca3Gala3(Fuca3)GlcNAcb-".

In the first case, the anomer is "a2". In the second case, the anomer is "?2".
}
\examples{
iupac <- "Neu5Aca3Gala3(Fuca6)GlcNAcb-"
parse_iupac_short(iupac)

}
\seealso{
\code{\link[=parse_iupac_condensed]{parse_iupac_condensed()}}, \code{\link[=parse_iupac_extended]{parse_iupac_extended()}}
}
