% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_splitcorr.R
\name{gg_splitcorr}
\alias{gg_splitcorr}
\title{Split-Correlation Heatmap}
\usage{
gg_splitcorr(
  data,
  split,
  style = "tile",
  method = "pearson",
  padjust = "BH",
  use = "complete.obs",
  colors = c("blue", "white", "red"),
  text_colors = c("white", "black"),
  text_size = 3.5,
  border_color = "black",
  prefix = NULL,
  linetype = "dashed",
  linealpha = 0.5,
  offset = 0.75
)
}
\arguments{
\item{data}{A data frame containing numeric variables to correlate and the
variable to split by.}

\item{split}{A character string specifying the name of the binary variable
in \code{data} used to split the dataset.}

\item{style}{Type of visualization; either \code{"tile"} (default) for a
heatmap or \code{"point"} for a bubble-style plot.}

\item{method}{Correlation method to use; either \code{"pearson"} (default)
or \code{"spearman"}.}

\item{padjust}{Method for p-value adjustment, passed to
\code{\link[stats]{p.adjust}} (default \code{"BH"}).}

\item{use}{Handling of missing values, passed to
\code{\link[stats]{cor}} (default \code{"complete.obs"}).}

\item{colors}{A vector of three colors for the low, mid, and high values
of the correlation scale (default \code{c("blue", "white", "red")}).}

\item{text_colors}{A vector of two colors for the text labels, used for
negative and positive correlations (default \code{c("white", "black")}).}

\item{text_size}{Numeric value giving the size of correlation text labels
(default \code{3.5}).}

\item{border_color}{Color for tile or point borders (default \code{"black"}).}

\item{prefix}{Character string prefix for group labels. If NULL (default),
uses "split_variable = " format. Default is NULL.}

\item{linetype}{Type of diagonal line separating upper and lower triangles;
one of \code{"solid"}, \code{"dashed"}, or \code{"dotdash"} (default \code{"dashed"}).}

\item{linealpha}{Alpha transparency for the diagonal line (default \code{0.5}).}

\item{offset}{Numeric offset for the position of the group labels (default \code{0.75}).}
}
\value{
A ggplot2 object showing the split-correlation heatmap. The plot displays:
\itemize{
\item Upper triangle: correlations for the first level of the split variable
\item Lower triangle: correlations for the second level of the split variable
\item Diagonal line separating the two triangles
\item Group labels indicating which split level is shown in each triangle
\item Correlation values displayed only for significant pairs (p < 0.05 after adjustment)
\item Color gradient representing correlation strength (-1 to 1)
\item Optional point size (if \code{style = "point"}) indicating absolute correlation strength
}
}
\description{
Creates a split-correlation plot where the upper triangle shows correlations
for one subgroup and the lower triangle for another, based on a binary
splitting variable. This allows quick visual comparison of correlation
structures between two groups. Significant correlations (after multiple
testing adjustment) can be labeled directly in the plot.
}
\details{
The function:
\enumerate{
\item Splits the dataset into two groups using the variable specified by \code{split}.
\item Computes pairwise correlations and p-values for each group (via a helper \code{cor_p()}).
\item Combines the upper triangle from one group and lower triangle from the other.
\item Adjusts p-values using the selected method and annotates significant cells.
}
The result is a heatmap (or bubble plot) showing both groups' correlation patterns
in a single compact visualization.
}
\examples{
# Compare correlations between V-shaped vs straight engines
data(mtcars)

gg_splitcorr(
  data = mtcars,
  split = "vs",
  prefix = "Engine Type: "
)

# Alternative style "point"
gg_splitcorr(
  data = mtcars,
  split = "vs",
  style = "point",
  method = "spearman",
  prefix = "Engine Type: "
)
}
\seealso{
\code{\link[stats]{cor}} for correlation computation,
\code{\link[stats]{p.adjust}} for multiple testing correction,
\code{\link[ggplot2]{geom_tile}},
\code{\link[ggplot2]{geom_point}}
}
