% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities-labels.R
\name{sprintf_dm}
\alias{sprintf_dm}
\alias{value2char}
\title{Format numeric values as strings}
\usage{
sprintf_dm(fmt, ..., decimal.mark = getOption("OutDec", default = "."))

value2char(
  value,
  digits = Inf,
  format = "g",
  output.type = "expression",
  decimal.mark = getOption("OutDec", default = ".")
)
}
\arguments{
\item{fmt}{character as in \code{sprintf()}.}

\item{...}{as in \code{sprintf()}.}

\item{decimal.mark}{character If \code{NULL} or \code{NA} no substitution is
attempted and the value returned by \code{sprintf()} is returned as is.}

\item{value}{numeric The value of the estimate.}

\item{digits}{integer Number of digits to which numeric values are formatted.}

\item{format}{character One of "e", "f" or "g" for exponential, fixed, or
significant digits formatting.}

\item{output.type}{character One of "expression", "latex", "tex", "text",
"tikz", "markdown".}
}
\description{
Using \code{\link{sprintf}} flexibly format numbers as character strings
encoded for parsing into R expressions or using LaTeX or markdown
notation.
}
\details{
These functions are used to format the character strings returned,
  which can be used as labels in plots. Encoding used for the formatting is
  selected by the argument passed to \code{output.type}, thus, supporting
  different R graphic devices.
}
\examples{

sprintf_dm("\%2.3f", 2.34)
sprintf_dm("\%2.3f", 2.34, decimal.mark = ",")


value2char(2.34)
value2char(2.34, digits = 3, format = "g")
value2char(2.34, digits = 3, format = "f")
value2char(2.34, output.type = "text")
value2char(2.34, output.type = "text", format = "f")
value2char(2.34, output.type = "text", format = "g")

}
\seealso{
\code{\link[base]{sprintf}}
}
