% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_boundary_cn.R
\name{geom_boundary_cn}
\alias{geom_boundary_cn}
\title{Plot Boundaries of China}
\usage{
geom_boundary_cn(
  crs = "+proj=aeqd +lat_0=35 +lon_0=105 +ellps=WGS84 +units=m +no_defs",
  compass = FALSE,
  scale = FALSE,
  mainland_color = "black",
  mainland_size = 0.2,
  mainland_linetype = "solid",
  coastline_color = "blue",
  coastline_size = 0.1,
  coastline_linetype = "solid",
  ten_segment_line_color = "black",
  ten_segment_line_size = 0.2,
  ten_segment_line_linetype = "solid",
  SAR_boundary_color = "grey40",
  SAR_boundary_size = 0.1,
  SAR_boundary_linetype = "dashed",
  undefined_boundary_color = "black",
  undefined_boundary_size = 0.2,
  undefined_boundary_linetype = "dotdash",
  province_color = "transparent",
  province_size = 0.1,
  province_linetype = "solid",
  ...
)
}
\arguments{
\item{crs}{Character or `sf::crs`. Target coordinate reference system for
plotting. Defaults to an azimuthal equidistant projection centered on China
(`+proj=aeqd +lat_0=35 +lon_0=105 +ellps=WGS84 +units=m +no_defs`).}

\item{compass}{Logical. If `TRUE`, add a compass pointing to true north in
the top-left corner. Default: `FALSE`.}

\item{scale}{Logical. If `TRUE`, add a scale bar in the bottom-left corner.
Default: `FALSE`.}

\item{mainland_color}{Character. Line color for the mainland boundary.
Default: `"black"`.}

\item{mainland_size}{Numeric. Line width for the mainland boundary.
Default: `0.2`.}

\item{mainland_linetype}{Character. Line type for the mainland boundary.
Default: `"solid"`.}

\item{coastline_color}{Character. Line color for coastlines.
Default: `"blue"`.}

\item{coastline_size}{Numeric. Line width for coastlines.
Default: `0.1`.}

\item{coastline_linetype}{Character. Line type for coastlines.
Default: `"solid"`.}

\item{ten_segment_line_color}{Character. Line color for the South China Sea
ten-segment line. Default: `"black"`.}

\item{ten_segment_line_size}{Numeric. Line width for the ten-segment line.
Default: `0.2`.}

\item{ten_segment_line_linetype}{Character. Line type for the ten-segment line.
Default: `"solid"`.}

\item{SAR_boundary_color}{Character. Line color for Hong Kong and Macau SAR
boundaries. Default: `"grey40"`.}

\item{SAR_boundary_size}{Numeric. Line width for SAR boundaries.
Default: `0.1`.}

\item{SAR_boundary_linetype}{Character. Line type for SAR boundaries.
Default: `"dashed"`.}

\item{undefined_boundary_color}{Character. Line color for undefined or
disputed boundaries. Default: `"black"`.}

\item{undefined_boundary_size}{Numeric. Line width for undefined boundaries.
Default: `0.2`.}

\item{undefined_boundary_linetype}{Character. Line type for undefined
boundaries. Default: `"dotdash"`.}

\item{province_color}{Character. Line color for provincial boundaries.
Default: `"transparent"`.}

\item{province_size}{Numeric. Line width for provincial boundaries.
Default: `0.1`.}

\item{province_linetype}{Character. Line type for provincial boundaries.
Default: `"solid"`.}

\item{...}{Additional arguments passed to `ggplot2::geom_sf()` (e.g., `alpha`).}
}
\value{
A list of `ggplot2` layers. If the boundary dataset cannot be
  obtained, an empty list is returned.
}
\description{
Draw China's administrative boundaries and optional map decorations
(compass and scale bar). Each boundary category (mainland, coastline,
provinces, etc.) can be styled independently. The boundary data are
reprojected to the specified CRS before plotting.
}
\examples{
\dontshow{if (requireNamespace("sf", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Example 1: Basic China map
ggplot() +
  geom_boundary_cn() +
  theme_minimal()

# Example 2: Add compass and scale bar (easy mode)
ggplot() +
  geom_boundary_cn(compass = TRUE, scale = TRUE) +
  theme_minimal()

# Example 3: Custom styling
ggplot() +
  geom_boundary_cn(
    coastline_color  = "steelblue",
    province_color   = "grey70",
    province_linetype = "dashed"
  ) +
  theme_minimal()

# Example 4: Advanced usage with a custom projected CRS (Albers)
albers_cn <- "+proj=aea +lat_1=25 +lat_2=47 +lat_0=0 +lon_0=105 +datum=WGS84 +units=m +no_defs"

ggplot() +
  geom_boundary_cn(crs = albers_cn) +
  annotation_compass(location = "tl", which_north = "true") +
  annotation_scalebar(location = "bl", fixed_width = 500000, display_unit = "km") +
  coord_sf(crs = albers_cn) +
  theme_minimal()
\dontshow{\}) # examplesIf}
}
