% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-crossbar-sample.R,
%   R/geom-errorbar-sample.R, R/geom-linerange-sample.R,
%   R/geom-pointrange-sample.R
\name{geom_crossbar_sample}
\alias{geom_crossbar_sample}
\alias{geom_errorbar_sample}
\alias{geom_linerange_sample}
\alias{geom_pointrange_sample}
\title{Vertical intervals: lines, crossbars & errorbars with uncertainty}
\usage{
geom_crossbar_sample(
  mapping = NULL,
  data = NULL,
  times = 10,
  seed = NULL,
  stat = "identity_sample",
  position = "identity",
  ...,
  middle.colour = NULL,
  middle.color = NULL,
  middle.linetype = NULL,
  middle.linewidth = NULL,
  box.colour = NULL,
  box.color = NULL,
  box.linetype = NULL,
  box.linewidth = NULL,
  fatten = deprecated(),
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_errorbar_sample(
  mapping = NULL,
  data = NULL,
  stat = "identity_sample",
  position = "identity",
  ...,
  times = 10,
  orientation = NA,
  seed = NULL,
  lineend = "butt",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_linerange_sample(
  mapping = NULL,
  data = NULL,
  stat = "identity_sample",
  position = "identity",
  ...,
  times = 10,
  orientation = NA,
  seed = NULL,
  lineend = "butt",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_pointrange_sample(
  mapping = NULL,
  data = NULL,
  stat = "identity_sample",
  position = "identity",
  ...,
  times = 10,
  orientation = NA,
  seed = NULL,
  lineend = "butt",
  fatten = 4,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{times}{A parameter used to control the number of values sampled from 
each distribution.}

\item{seed}{Set the seed for the layers random draw, allows you to plot the
same draw across multiple layers.}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used to override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{middle.colour, middle.color, middle.linetype, middle.linewidth}{Default aesthetics for the middle line. Set to \code{NULL} to inherit from the
data's aesthetics.}

\item{box.colour, box.color, box.linetype, box.linewidth}{Default aesthetics for the boxes. Set to \code{NULL} to inherit from the
data's aesthetics.}

\item{fatten}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}  A multiplicative factor
used to increase the size of the middle bar in \code{geom_crossbar()} and the
middle point in \code{geom_pointrange()}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{lineend}{Line end style (round, butt, square).}
}
\value{
A ggplot2 layer
}
\description{
Identical to geom_linerange, geom_errorbar, geom_crossbar, and 
geom_pointrange except that they will accept a distribution in place of 
any of the usual aesthetics.
}
\examples{
library(ggplot2)
library(dplyr)
library(distributional)
# Create a simple example dataset

df <- data.frame(
  trt = factor(c(1, 1, 2, 2)),
  resp = c(1, 5, 3, 4),
  group = factor(c(1, 2, 1, 2)),
  upper = c(1.1, 5.3, 3.3, 4.2),
  lower = c(0.8, 4.6, 2.4, 3.6)
)

uncertain_df <- df |>
  group_by(trt, group) |>
  mutate(resp = dist_normal(resp, runif(1,0,0.2)),
         upper = dist_normal(upper, runif(1,0,0.2)),
         lower = dist_normal(lower, runif(1,0,0.2))
  )

p <- ggplot(df, aes(trt, resp, colour = group))
q <- ggplot(uncertain_df, aes(trt, resp, colour = group))

# ggplot
p + geom_linerange(aes(ymin = lower, ymax = upper), linewidth=4)
#ggdibbler
q + geom_linerange_sample(aes(ymin = lower, ymax = upper), linewidth=4)

# ggplot
p + geom_pointrange(aes(ymin = lower, ymax = upper))
# ggdibbler
q + geom_pointrange_sample(aes(ymin = lower, ymax = upper)) 

# ggplot
p + geom_crossbar(aes(ymin = lower, ymax = upper), width = 0.2)
# ggdibbler
q + geom_crossbar_sample(aes(ymin = lower, ymax = upper), width = 0.2)

# ggplot
p + geom_errorbar(aes(ymin = lower, ymax = upper), width = 0.2)
# ggdibbler
q + geom_errorbar_sample(aes(ymin = lower, ymax = upper), width = 0.2)
}
