% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-quasirandom.R
\name{position_quasirandom}
\alias{position_quasirandom}
\title{Arrange points using quasirandom noise to avoid overplotting}
\usage{
position_quasirandom(
  method = "quasirandom",
  width = NULL,
  varwidth = FALSE,
  bandwidth = 0.5,
  nbins = NULL,
  dodge.width = 0,
  orientation = NULL,
  groupOnX = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{method}{Method used for distributing points.
Options are \code{"quasirandom"} (default), \code{"pseudorandom"}, \code{"smiley"}, \code{"maxout"}, \code{"frowney"}, \code{"minout"}, \code{"tukey"}, \code{"tukeyDense"}.
See \code{\link[vipor:offsetX]{vipor::offsetSingleGroup()}} for the details of each method.}

\item{width}{Maximum amount of spread (default: 0.4)}

\item{varwidth}{Vary the width by the relative size of each group. (default: \code{FALSE})}

\item{bandwidth}{the bandwidth adjustment to use when calculating density
Smaller numbers (< 1) produce a tighter "fit". (default: 0.5)}

\item{nbins}{the number of bins used when calculating density
(has little effect with quasirandom/random distribution)}

\item{dodge.width}{Amount by which points from different aesthetic groups
will be dodged. This requires that one of the aesthetics is a factor.
To disable dodging between groups, set this to NULL. (default: 0)}

\item{orientation}{The orientation (i.e., which axis to group on) is inferred from the data.
This can be overridden by setting \code{orientation} to either \code{"x"} or \code{"y"}.}

\item{groupOnX}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} See \code{orientation}.}

\item{na.rm}{if \code{FALSE} (default), missing values are removed with a warning.
If \code{TRUE}, missing values are silently removed.}
}
\description{
Arrange points using quasirandom noise to avoid overplotting
}
\seealso{
\code{\link[vipor:offsetX]{vipor::offsetSingleGroup()}}, \code{\link[=geom_quasirandom]{geom_quasirandom()}}

Other position adjustments: 
\code{\link{offset_beeswarm}()},
\code{\link{position_beeswarm}()}
}
\concept{position adjustments}
