% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-vegetation-indices.R
\name{calculate_ndvi_enhanced}
\alias{calculate_ndvi_enhanced}
\title{Calculate NDVI with time series options}
\usage{
calculate_ndvi_enhanced(
  red_data,
  nir_data,
  clamp_range = c(-0.2, 1),
  match_by_date = FALSE,
  quality_filter = FALSE,
  temporal_smoothing = FALSE,
  verbose = FALSE,
  date_patterns = NULL
)
}
\arguments{
\item{red_data}{Red band data (files, directory, or raster objects)}

\item{nir_data}{NIR band data (files, directory, or raster objects)}

\item{clamp_range}{Range to clamp NDVI values (default: c(-0.2, 1))}

\item{match_by_date}{Logical: match rasters by date using filenames}

\item{quality_filter}{Apply quality filtering (remove outliers)}

\item{temporal_smoothing}{Apply temporal smoothing for time series}

\item{verbose}{Print progress messages}

\item{date_patterns}{Custom date patterns for matching}
}
\value{
SpatRaster with NDVI layers (single or multi-layer for time series)
}
\description{
NDVI calculation specifically designed for time series analysis with
date matching, quality filtering, temporal smoothing, and multi-temporal support.
\strong{Use this for time series analysis, use calculate_vegetation_index() for single dates.}
}
\details{
\subsection{When to Use Enhanced vs Basic NDVI:}{
\subsection{Use \code{calculate_ndvi_enhanced()} for:}{
\itemize{
\item \strong{Time series analysis}: Multiple dates, trend analysis
\item \strong{Quality control}: Remove outliers, temporal smoothing
\item \strong{Date matching}: Automatic pairing of red/NIR by date
\item \strong{Multi-temporal studies}: Seasonal analysis, change detection
}
}

\subsection{Use \code{calculate_vegetation_index(index_type="NDVI")} for:}{
\itemize{
\item \strong{Single date analysis}: One-time calculation
\item \strong{Different indices}: Want to calculate EVI, SAVI, etc. too
\item \strong{Quick calculations}: Simple, fast NDVI
\item \strong{Mixed workflows}: Part of larger vegetation index analysis
}
}

}
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Time series NDVI with date matching
ndvi_series <- calculate_ndvi_enhanced(
  red_data = "/path/to/red/time_series/",
  nir_data = "/path/to/nir/time_series/",
  match_by_date = TRUE,
  quality_filter = TRUE,
  temporal_smoothing = TRUE
)

# Simple NDVI (single date with quality control)
ndvi_clean <- calculate_ndvi_enhanced(
  red_data = red_raster,
  nir_data = nir_raster,
  quality_filter = TRUE
)
}

}
