% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seam.R
\name{seam_adj}
\alias{seam_adj}
\title{Filter Adjacency to Edges Along Border}
\usage{
seam_adj(adj, shp, admin, seam, epsg = 3857)
}
\arguments{
\item{adj}{zero indexed adjacency graph}

\item{shp}{tibble to subset and where admin column is found}

\item{admin}{quoted name of administrative unit column}

\item{seam}{administrative units to filter by}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}
}
\value{
subset of adj
}
\description{
Filter Adjacency to Edges Along Border
}
\examples{
data('rockland')
data('orange')
data('nrcsd')

o_and_r <- rbind(orange, rockland)
o_and_r <- o_and_r |>
  geo_filter(nrcsd) |>
  geo_trim(nrcsd)
adj <- adjacency(o_and_r)

seam_adj(adj, shp = o_and_r, admin = 'county', seam = c('071', '087'))

}
\concept{seam}
