% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geojson_sf.R
\name{geojson_sfc}
\alias{geojson_sfc}
\title{Geojson to sfc}
\usage{
geojson_sfc(
  geojson,
  expand_geometries = FALSE,
  input = NULL,
  wkt = NULL,
  crs = NULL,
  proj4string = NULL,
  buffer_size = 1024
)
}
\arguments{
\item{geojson}{string or vector of GeoJSON, or a URL or file pointing to a geojson file}

\item{expand_geometries}{logical indicating whether to unnest GEOMETRYCOLLECTION rows. see details}

\item{input}{user input for coordinate reference system object}

\item{wkt}{well-known text for coordinate reference system object}

\item{crs}{deprecated. coordinate reference system. See Details}

\item{proj4string}{deprecated. proj4string. See Details}

\item{buffer_size}{size of buffer used when reading a file from disk. Defaults 1024}
}
\description{
Extracts geometries from GeoJSON and returns an `sfc` object
}
\details{
specifying \code{expand_geometries = TRUE} will expand individual \code{GEOMETRYCOLLECTION}
geometries to their own row in the resulting `sf` object. If the geometries are part
of a \code{Feature} (i.e., with properties), the properties will be repeated on each row.

The \code{GEOMETRYCOLLECTION} information is not kept when using \code{expand_geometries = TRUE}. Therefore,
it is not possible to reconstruct the \code{GEOMETRYCOLLECTION} after unnesting it.

Geojson specification RFC7946 \url{https://datatracker.ietf.org/doc/html/rfc7946#page-12}
says all CRS should be the World Geodetic System 1984 (WGS 84) [WGS84] datum,
with longitude and latitude units of decimal degrees.  This is equivalent to
the coordinate reference system identified by the Open Geospatial Consortium (OGC)
URN urn:ogc:def:crs:OGC::CRS84

\code{geojson_sfc} and \code{geojson_sf} automatically set the CRS to WGS 84.
The fields \code{input} and \code{wkt} let you to overwrite the defaults.
}
\examples{

## character string of GeoJSON

## load 'sf' for print methods
# library(sf)
geojson <- '{ "type":"Point","coordinates":[0,0] }'
geojson_sfc(geojson)

geojson <- '[
  { "type":"Point","coordinates":[0,0]},
  {"type":"LineString","coordinates":[[0,0],[1,1]]}
  ]'
geojson_sfc( geojson )

\dontrun{
## GeoJSON at a url
myurl <- "http://eric.clst.org/assets/wiki/uploads/Stuff/gz_2010_us_050_00_500k.json"
sf <- geojson_sfc(myurl)
}

}
